/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Constants;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.NodeTest;
import org.exist.xquery.Predicate;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public abstract class Step
extends AbstractExpression {
    protected static final Logger LOG = LogManager.getLogger(Step.class);
    protected int axis = -1;
    protected boolean abbreviatedStep = false;
    protected List<Predicate> predicates = new CopyOnWriteArrayList<Predicate>();
    protected NodeTest test;
    protected boolean inPredicate = false;
    protected int staticReturnType = 11;
    protected boolean hasPositionalPredicate = false;

    public Step(XQueryContext context, int axis) {
        super(context);
        this.axis = axis;
    }

    public Step(XQueryContext context, int axis, NodeTest test) {
        this(context, axis);
        this.test = test;
    }

    public void addPredicate(Expression expr) {
        this.predicates.add((Predicate)expr);
    }

    public void insertPredicate(Expression previous, Expression predicate) {
        int idx = this.predicates.indexOf(previous);
        if (idx < 0) {
            LOG.warn("Old predicate not found: " + ExpressionDumper.dump(previous) + "; in: " + ExpressionDumper.dump(this));
            return;
        }
        this.predicates.add(idx + 1, (Predicate)predicate);
    }

    public boolean hasPredicates() {
        return this.predicates.size() > 0;
    }

    public List<Predicate> getPredicates() {
        return this.predicates;
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        if (this.test != null && this.test.getName() != null && this.test.getName().getPrefix() != null && !"".equals(this.test.getName().getPrefix()) && this.context.inScopePrefixes != null && this.context.getURIForPrefix(this.test.getName().getPrefix()) == null) {
            throw new XPathException((Expression)this, ErrorCodes.XPST0081, "undeclared prefix '" + this.test.getName().getPrefix() + "'");
        }
        this.inPredicate = (contextInfo.getFlags() & 2) > 0;
        this.contextId = contextInfo.getContextId();
        if (this.predicates.size() > 0) {
            AnalyzeContextInfo newContext = new AnalyzeContextInfo(contextInfo);
            newContext.setStaticType(this.axis == 12 ? contextInfo.getStaticType() : -1);
            newContext.setParent(this);
            newContext.setContextStep(this);
            for (Predicate pred : this.predicates) {
                pred.analyze(newContext);
            }
            if (this.predicates.size() == 1 && (newContext.getFlags() & 0x40) != 0) {
                this.hasPositionalPredicate = true;
            }
        }
        if (this.axis == 12) {
            this.staticReturnType = contextInfo.getStaticType();
        }
    }

    @Override
    public abstract Sequence eval(Sequence var1, Item var2) throws XPathException;

    public int getAxis() {
        return this.axis;
    }

    @Override
    public void setPrimaryAxis(int axis) {
        this.axis = axis;
    }

    @Override
    public int getPrimaryAxis() {
        return this.axis;
    }

    public boolean isAbbreviated() {
        return this.abbreviatedStep;
    }

    public void setAbbreviated(boolean abbrev) {
        this.abbreviatedStep = abbrev;
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        if (this.axis != -1) {
            dumper.display(Constants.AXISSPECIFIERS[this.axis]);
        }
        dumper.display("::");
        if (this.test != null) {
            dumper.display(this.test.toString());
        } else {
            dumper.display("node()");
        }
        if (this.predicates.size() > 0) {
            for (Predicate pred : this.predicates) {
                pred.dump(dumper);
            }
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.axis != -1) {
            result.append(Constants.AXISSPECIFIERS[this.axis]);
        }
        result.append("::");
        if (this.test != null) {
            result.append(this.test.toString());
        } else {
            result.append("node()");
        }
        if (this.predicates.size() > 0) {
            for (Predicate pred : this.predicates) {
                result.append(pred.toString());
            }
        }
        return result.toString();
    }

    @Override
    public int returnsType() {
        if (this.axis == 12) {
            return this.staticReturnType;
        }
        return -1;
    }

    @Override
    public int getCardinality() {
        return 7;
    }

    public void setAxis(int axis) {
        this.axis = axis;
    }

    public void setTest(NodeTest test) {
        this.test = test;
    }

    public NodeTest getTest() {
        return this.test;
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        for (Predicate pred : this.predicates) {
            pred.resetState(postOptimization);
        }
    }
}

