/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.ArrayList;
import java.util.List;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.StringValue;

public class StringConstructor
extends AbstractExpression {
    protected List<StringConstructorPart> content = new ArrayList<StringConstructorPart>(13);

    public StringConstructor(XQueryContext context) {
        super(context);
    }

    public void addContent(String str) {
        this.content.add(new StringConstructorContent(str));
    }

    public void addInterpolation(Expression expression) {
        this.content.add(new StringConstructorInterpolation(expression));
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        if (this.getContext().getXQueryVersion() < 31) {
            throw new XPathException((Expression)this, ErrorCodes.EXXQDY0003, "string constructors are not available before XQuery 3.1");
        }
        for (StringConstructorPart p : this.content) {
            p.analyze(contextInfo);
        }
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        StringBuilder out = new StringBuilder();
        for (StringConstructorPart p : this.content) {
            out.append(p.eval(contextSequence));
        }
        return new StringValue(out.toString());
    }

    @Override
    public int returnsType() {
        return 22;
    }

    @Override
    public int getCardinality() {
        return 2;
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        dumper.display("``[");
        this.content.forEach(p -> p.dump(dumper));
        dumper.display("``]");
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.content.forEach(p -> p.resetState(postOptimization));
    }

    private static class StringConstructorInterpolation
    implements StringConstructorPart {
        private final Expression expression;

        StringConstructorInterpolation(Expression expression) {
            this.expression = expression;
        }

        @Override
        public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
            this.expression.analyze(contextInfo);
        }

        @Override
        public String eval(Sequence contextSequence) throws XPathException {
            Sequence result = this.expression.eval(contextSequence);
            StringBuilder out = new StringBuilder();
            boolean gotOne = false;
            SequenceIterator i = result.iterate();
            while (i.hasNext()) {
                Item next = i.nextItem();
                if (gotOne) {
                    out.append(' ');
                }
                out.append(next.getStringValue());
                gotOne = true;
            }
            return out.toString();
        }

        @Override
        public void dump(ExpressionDumper dumper) {
            dumper.display("`{");
            this.expression.dump(dumper);
            dumper.display("}`");
        }

        @Override
        public void resetState(boolean postOptimization) {
            this.expression.resetState(postOptimization);
        }
    }

    private static class StringConstructorContent
    implements StringConstructorPart {
        private final String content;

        StringConstructorContent(String content) {
            this.content = content;
        }

        @Override
        public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        }

        @Override
        public String eval(Sequence contextSequence) throws XPathException {
            return this.content;
        }

        @Override
        public void dump(ExpressionDumper dumper) {
            dumper.display(this.content);
        }

        @Override
        public void resetState(boolean postOptimization) {
        }
    }

    private static interface StringConstructorPart {
        public void analyze(AnalyzeContextInfo var1) throws XPathException;

        public String eval(Sequence var1) throws XPathException;

        public void dump(ExpressionDumper var1);

        public void resetState(boolean var1);
    }
}

