/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import javax.xml.stream.XMLStreamReader;
import org.exist.dom.QName;
import org.exist.dom.persistent.NodeProxy;
import org.exist.stax.StaXUtil;
import org.exist.xquery.NodeTest;
import org.exist.xquery.value.Type;
import org.w3c.dom.Node;

public class TypeTest
implements NodeTest {
    protected int nodeType = 0;

    public TypeTest(int nodeType) {
        this.setType(nodeType);
    }

    @Override
    public void setType(int nodeType) {
        this.nodeType = nodeType;
    }

    @Override
    public int getType() {
        return this.nodeType;
    }

    @Override
    public QName getName() {
        return null;
    }

    protected boolean isOfType(short type) {
        short domType;
        switch (this.nodeType) {
            case 1: {
                domType = 1;
                break;
            }
            case 3: {
                domType = 3;
                break;
            }
            case 2: {
                domType = 2;
                break;
            }
            case 5: {
                domType = 8;
                break;
            }
            case 4: {
                domType = 7;
                break;
            }
            case 500: {
                domType = 13;
                break;
            }
            case 6: {
                domType = 9;
                break;
            }
            default: {
                return true;
            }
        }
        if (type == 4) {
            type = (short)3;
        }
        return type == domType;
    }

    public boolean isOfEventType(int type) {
        if (this.nodeType == -1) {
            return true;
        }
        int xpathType = StaXUtil.streamType2Type(type);
        return xpathType == this.nodeType;
    }

    public String toString() {
        return Type.getTypeName(this.nodeType);
    }

    @Override
    public boolean matches(NodeProxy proxy) {
        short otherNodeType = proxy.getNodeType();
        if (otherNodeType == 11 || otherNodeType == -1) {
            return this.nodeType == -1 || this.isOfType(proxy.getNode().getNodeType());
        }
        return this.isOfType(otherNodeType);
    }

    @Override
    public boolean matches(Node other) {
        return other != null && this.isOfType(other.getNodeType());
    }

    @Override
    public boolean matches(XMLStreamReader reader) {
        return this.isOfEventType(reader.getEventType());
    }

    @Override
    public boolean matches(QName name) {
        return false;
    }

    @Override
    public boolean isWildcardTest() {
        return true;
    }
}

