/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.xquery.Constants;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.PathExpr;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;

public class UnaryExpr
extends PathExpr {
    private final Constants.ArithmeticOperator mode;

    public UnaryExpr(XQueryContext context, Constants.ArithmeticOperator mode) {
        super(context);
        assert (mode == Constants.ArithmeticOperator.ADDITION || mode == Constants.ArithmeticOperator.SUBTRACTION);
        this.mode = mode;
    }

    @Override
    public int returnsType() {
        return 32;
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if (this.getLength() == 0) {
            throw new XPathException((Expression)this, "unary expression requires an operand");
        }
        Sequence item = this.getExpression(0).eval(contextSequence);
        if (item.isEmpty()) {
            return item;
        }
        NumericValue value = (NumericValue)item.convertTo(30);
        NumericValue result = this.mode == Constants.ArithmeticOperator.SUBTRACTION ? value.negate() : value;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        dumper.display(this.mode.symbol);
    }

    @Override
    public String toString() {
        return this.mode.symbol;
    }

    @Override
    public Expression simplify() {
        return this;
    }
}

