/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.persistent.DocumentSet;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Atomize;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.parser.XQueryAST;
import org.exist.xquery.util.Error;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public class UntypedValueCheck
extends AbstractExpression {
    private final Expression expression;
    private final int requiredType;
    private final Error error;
    private final boolean atomize;

    public UntypedValueCheck(XQueryContext context, int requiredType, Expression expression) {
        this(context, requiredType, expression, new Error("D04"));
    }

    public UntypedValueCheck(XQueryContext context, int requiredType, Expression expression, Error error) {
        super(context);
        this.requiredType = requiredType;
        if (expression instanceof Atomize && requiredType != 20) {
            this.expression = ((Atomize)expression).getExpression();
            this.atomize = true;
        } else {
            this.expression = expression;
            this.atomize = false;
        }
        this.error = error;
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.expression.analyze(contextInfo);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        Sequence seq = this.expression.eval(contextSequence, contextItem);
        Sequence result = null;
        if (seq.hasOne()) {
            Item item = this.convert(seq.itemAt(0));
            if (item != null) {
                result = item.toSequence();
            }
        } else {
            result = new ValueSequence();
            SequenceIterator i = seq.iterate();
            while (i.hasNext()) {
                Item item = i.nextItem();
                item = this.convert(item);
                result.add(item);
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    private Item convert(Item item) throws XPathException {
        if (this.atomize || item.getType() == 21 || Type.subTypeOf(this.requiredType, 30) && Type.subTypeOf(item.getType(), 30)) {
            try {
                if (Type.subTypeOf(item.getType(), this.requiredType)) {
                    return item;
                }
                item = item.convertTo(this.requiredType);
            }
            catch (XPathException e) {
                this.error.addArgs(ExpressionDumper.dump(this.expression), Type.getTypeName(this.requiredType), Type.getTypeName(item.getType()));
                throw new XPathException(this.expression, this.error.toString());
            }
        }
        return item;
    }

    public DocumentSet preselect(DocumentSet in_docs) throws XPathException {
        return in_docs;
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        dumper.display("untyped-value-check[");
        dumper.display(Type.getTypeName(this.requiredType));
        dumper.display(", ");
        this.expression.dump(dumper);
        dumper.display("]");
    }

    public String toString() {
        return this.expression.toString();
    }

    @Override
    public int returnsType() {
        return this.requiredType;
    }

    @Override
    public int getDependencies() {
        return this.expression.getDependencies();
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.expression.resetState(postOptimization);
    }

    @Override
    public void setContextDocSet(DocumentSet contextSet) {
        super.setContextDocSet(contextSet);
        this.expression.setContextDocSet(contextSet);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        this.expression.accept(visitor);
    }

    @Override
    public void setASTNode(XQueryAST ast) {
        this.expression.setASTNode(ast);
    }

    @Override
    public void setLocation(int line, int column) {
        this.expression.setLocation(line, column);
    }

    @Override
    public int getLine() {
        return this.expression.getLine();
    }

    @Override
    public int getColumn() {
        return this.expression.getColumn();
    }

    @Override
    public int getSubExpressionCount() {
        return 1;
    }

    @Override
    public Expression getSubExpression(int index) {
        if (index == 0) {
            return this.expression;
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.getSubExpressionCount());
    }
}

