/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exist.source.Source;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.UserDefinedFunction;
import org.exist.xquery.XPathErrorProvider;
import org.exist.xquery.parser.XQueryAST;
import org.exist.xquery.value.Sequence;

public class XPathException
extends Exception
implements XPathErrorProvider {
    private static final long serialVersionUID = 212844692232650666L;
    private int line = 0;
    private int column = 0;
    private ErrorCodes.ErrorCode errorCode = ErrorCodes.ERROR;
    private String message = null;
    private Sequence errorVal;
    private List<FunctionStackElement> callStack = null;
    private Source source = null;

    @Deprecated
    public XPathException(String message) {
        this.message = message;
    }

    @Deprecated
    public XPathException(int line, int column, String message) {
        this.message = message;
        this.line = line;
        this.column = column;
    }

    public XPathException(ErrorCodes.ErrorCode errorCode, int line, int column) {
        this.errorCode = errorCode;
        this.line = line;
        this.column = column;
    }

    public XPathException(int line, int column, ErrorCodes.ErrorCode errorCode, String message) {
        this.errorCode = errorCode;
        this.message = message;
        this.line = line;
        this.column = column;
    }

    @Deprecated
    public XPathException(Expression expr, String message) {
        this.message = message;
        this.line = expr.getLine();
        this.column = expr.getColumn();
        this.source = expr.getSource();
    }

    public XPathException(Expression expr, ErrorCodes.ErrorCode errorCode, String errorDesc) {
        this.errorCode = errorCode;
        this.message = errorDesc;
        this.line = expr.getLine();
        this.column = expr.getColumn();
        this.source = expr.getSource();
    }

    public XPathException(Expression expr, ErrorCodes.ErrorCode errorCode, String errorDesc, Sequence errorVal) {
        this.errorCode = errorCode;
        this.message = errorDesc;
        this.errorVal = errorVal;
        this.line = expr.getLine();
        this.column = expr.getColumn();
        this.source = expr.getSource();
    }

    public XPathException(Expression expr, ErrorCodes.ErrorCode errorCode, Throwable cause) {
        super(cause);
        this.errorCode = errorCode;
        this.message = cause.getMessage();
        this.line = expr.getLine();
        this.column = expr.getColumn();
        this.source = expr.getSource();
    }

    @Deprecated
    public XPathException(XQueryAST ast, String message) {
        this.message = message;
        if (ast != null) {
            this.line = ast.getLine();
            this.column = ast.getColumn();
        }
    }

    public XPathException(XQueryAST ast, ErrorCodes.ErrorCode errorCode, String message) {
        this.errorCode = errorCode;
        this.message = message;
        if (ast != null) {
            this.line = ast.getLine();
            this.column = ast.getColumn();
        }
    }

    @Deprecated
    public XPathException(Throwable cause) {
        super(cause);
        if (cause instanceof XPathErrorProvider) {
            this.errorCode = ((XPathErrorProvider)((Object)cause)).getErrorCode();
        }
    }

    @Deprecated
    public XPathException(String message, Throwable cause) {
        super(cause);
        this.message = message;
        if (cause instanceof XPathErrorProvider) {
            this.errorCode = ((XPathErrorProvider)((Object)cause)).getErrorCode();
        }
    }

    @Deprecated
    public XPathException(Expression expr, Throwable cause) {
        this(expr, cause instanceof XPathErrorProvider ? ((XPathErrorProvider)((Object)cause)).getErrorCode() : ErrorCodes.ERROR, cause.getMessage(), null, cause);
    }

    @Deprecated
    public XPathException(Expression expr, String message, Throwable cause) {
        this(expr, cause instanceof XPathErrorProvider ? ((XPathErrorProvider)((Object)cause)).getErrorCode() : ErrorCodes.ERROR, message, null, cause);
    }

    public XPathException(Expression expr, ErrorCodes.ErrorCode errorCode, String errorDesc, Sequence errorVal, Throwable cause) {
        this(expr.getLine(), expr.getColumn(), errorDesc, cause);
        this.errorCode = errorCode;
        this.errorVal = errorVal;
    }

    public XPathException(ErrorCodes.ErrorCode errorCode, String errorDesc, Sequence errorVal) {
        this(errorCode, errorDesc);
        this.errorVal = errorVal;
    }

    public XPathException(ErrorCodes.ErrorCode errorCode, String errorDesc) {
        this.errorCode = errorCode;
        this.message = errorDesc == null ? errorCode.toString() : errorDesc;
    }

    public XPathException(ErrorCodes.ErrorCode errorCode, String errorDesc, Sequence errorVal, Throwable cause) {
        this(errorCode, errorDesc, cause);
        this.errorVal = errorVal;
    }

    public XPathException(ErrorCodes.ErrorCode errorCode, String errorDesc, Throwable cause) {
        super(cause);
        this.errorCode = errorCode;
        this.message = errorDesc == null ? errorCode.toString() : errorDesc;
    }

    @Deprecated
    protected XPathException(int line, int column, String message, Throwable cause) {
        super(cause);
        this.message = message;
        this.line = line;
        this.column = column;
        if (cause instanceof XPathErrorProvider) {
            this.errorCode = ((XPathErrorProvider)((Object)cause)).getErrorCode();
        }
    }

    @Deprecated
    public XPathException(int line, int column, Throwable cause) {
        super(cause);
        this.line = line;
        this.column = column;
        if (cause instanceof XPathErrorProvider) {
            this.errorCode = ((XPathErrorProvider)((Object)cause)).getErrorCode();
        }
    }

    public void setLocation(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public void setLocation(int line, int column, Source source) {
        this.line = line;
        this.column = column;
        this.source = source;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    @Deprecated
    public ErrorCodes.ErrorCode getCode() {
        return this.errorCode;
    }

    public Source getSource() {
        return this.source;
    }

    public void addFunctionCall(UserDefinedFunction def, Expression call) {
        if (this.callStack == null) {
            this.callStack = new ArrayList<FunctionStackElement>();
        }
        this.callStack.add(new FunctionStackElement(def, def.getSource().path(), call.getLine(), call.getColumn()));
    }

    public List<FunctionStackElement> getCallStack() {
        return this.callStack;
    }

    public void prependMessage(String msg) {
        this.message = msg + this.message;
    }

    public void prependMessage(ErrorCodes.ErrorCode errorCode, String msg) {
        this.errorCode = errorCode;
        this.message = msg + this.message;
    }

    @Override
    public String getMessage() {
        StringBuilder buf = new StringBuilder();
        if (this.message == null) {
            this.message = "";
        }
        if (this.errorCode != null) {
            buf.append(this.errorCode.getErrorQName());
            buf.append(" ");
            if (this.message.isEmpty()) {
                this.message = this.errorCode.getDescription();
            }
        }
        buf.append(this.message);
        if (this.getLine() > 0 || this.source != null) {
            buf.append(" [");
            if (this.getLine() > 0) {
                buf.append("at line ");
                buf.append(this.getLine());
                buf.append(", column ");
                buf.append(this.getColumn());
                if (this.source != null) {
                    buf.append(", ");
                }
            }
            if (this.source != null) {
                buf.append("source: ").append(this.source.getKey());
            }
            buf.append("]");
        }
        if (this.callStack != null) {
            buf.append("\nIn function:\n");
            Iterator<FunctionStackElement> i = this.callStack.iterator();
            while (i.hasNext()) {
                FunctionStackElement stack = i.next();
                buf.append('\t').append(stack);
                if (!i.hasNext()) continue;
                buf.append('\n');
            }
        }
        return buf.toString();
    }

    public String getDetailMessage() {
        return this.message;
    }

    public String getMessageAsHTML() {
        StringBuilder buf = new StringBuilder();
        if (this.message == null) {
            this.message = "";
        }
        this.message = this.message.replaceAll("\r?\n", "<br/>");
        buf.append("<h2>").append(this.message);
        if (this.getLine() > 0) {
            buf.append(" [at line ");
            buf.append(this.getLine());
            buf.append(", column ");
            buf.append(this.getColumn());
            buf.append("]");
        }
        buf.append("</h2>");
        if (this.callStack != null) {
            buf.append("<table id=\"xquerytrace\">");
            buf.append("<caption>XQuery Stack Trace</caption>");
            for (FunctionStackElement e : this.callStack) {
                buf.append("<tr><td class=\"func\">").append(e.function).append("</td>");
                buf.append("<td class=\"lineinfo\">").append(e.line).append(':').append(e.column).append("</td>");
                buf.append("</tr>");
            }
            buf.append("</table>");
        }
        return buf.toString();
    }

    @Override
    public ErrorCodes.ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public Sequence getErrorVal() {
        return this.errorVal;
    }

    public static class FunctionStackElement {
        private final String function;
        private final String file;
        private final int line;
        private final int column;

        public FunctionStackElement(UserDefinedFunction func, String file, int line, int column) {
            this.function = func.toString();
            this.file = file;
            this.line = line;
            this.column = column;
        }

        public int getColumn() {
            return this.column;
        }

        public String getFile() {
            return this.file;
        }

        public String getFunction() {
            return this.function;
        }

        public int getLine() {
            return this.line;
        }

        public String toString() {
            return this.function + " [" + this.line + ":" + this.column + ":" + this.file + ']';
        }
    }
}

