/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.io.ByteArrayInputStream;
import java.net.URISyntaxException;
import java.util.List;
import org.exist.dom.memtree.DocumentBuilderReceiver;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.dom.memtree.NodeImpl;
import org.exist.dom.persistent.AVLTreeNodeSet;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.NodeProxy;
import org.exist.numbering.NodeId;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.util.serializer.DOMStreamer;
import org.exist.util.serializer.SerializerPool;
import org.exist.xmldb.LocalXMLResource;
import org.exist.xmldb.RemoteXMLResource;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AbstractSequence;
import org.exist.xquery.value.Base64BinaryValueType;
import org.exist.xquery.value.BinaryValueFromInputStream;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.FloatValue;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public class XPathUtil {
    public static final Sequence javaObjectToXPath(Object obj, XQueryContext context) throws XPathException {
        return XPathUtil.javaObjectToXPath(obj, context, true);
    }

    public static final Sequence javaObjectToXPath(Object obj, XQueryContext context, boolean expandChars) throws XPathException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Sequence) {
            return (Sequence)obj;
        }
        if (obj instanceof String) {
            StringValue v = new StringValue((String)obj);
            return expandChars ? v.expand() : v;
        }
        if (obj instanceof Boolean) {
            return BooleanValue.valueOf((Boolean)obj);
        }
        if (obj instanceof Float) {
            return new FloatValue(((Float)obj).floatValue());
        }
        if (obj instanceof Double) {
            return new DoubleValue((Double)obj);
        }
        if (obj instanceof Short) {
            return new IntegerValue(((Short)obj).shortValue(), 39);
        }
        if (obj instanceof Integer) {
            return new IntegerValue(((Integer)obj).intValue(), 38);
        }
        if (obj instanceof Long) {
            return new IntegerValue((Long)obj, 37);
        }
        if (obj instanceof byte[]) {
            return BinaryValueFromInputStream.getInstance(context, new Base64BinaryValueType(), new ByteArrayInputStream((byte[])obj));
        }
        if (obj instanceof ResourceSet) {
            AVLTreeNodeSet seq = new AVLTreeNodeSet();
            try {
                DBBroker broker = context.getBroker();
                ResourceIterator it = ((ResourceSet)obj).getIterator();
                while (it.hasMoreResources()) {
                    seq.add((Item)XPathUtil.getNode(broker, (XMLResource)it.nextResource()));
                }
            }
            catch (XMLDBException xe) {
                throw new XPathException("Failed to convert ResourceSet to node: " + xe.getMessage());
            }
            return seq;
        }
        if (obj instanceof XMLResource) {
            return XPathUtil.getNode(context.getBroker(), (XMLResource)obj);
        }
        if (obj instanceof Node) {
            DOMStreamer streamer = (DOMStreamer)SerializerPool.getInstance().borrowObject(DOMStreamer.class);
            try {
                MemTreeBuilder builder = new MemTreeBuilder(context);
                builder.startDocument();
                DocumentBuilderReceiver receiver = new DocumentBuilderReceiver(builder);
                streamer.setContentHandler(receiver);
                streamer.serialize((Node)obj, false);
                NodeImpl nodeImpl = builder.getDocument().getNode(1);
                return nodeImpl;
            }
            catch (SAXException e) {
                throw new XPathException("Failed to transform node into internal model: " + e.getMessage());
            }
            finally {
                SerializerPool.getInstance().returnObject(streamer);
            }
        }
        if (obj instanceof List) {
            boolean createNodeSequence = true;
            for (Object next : (List)obj) {
                if (next instanceof NodeProxy) continue;
                createNodeSequence = false;
            }
            AbstractSequence seq = createNodeSequence ? new AVLTreeNodeSet() : new ValueSequence();
            for (Object o : (List)obj) {
                seq.add((Item)((Object)XPathUtil.javaObjectToXPath(o, context, expandChars)));
            }
            return seq;
        }
        if (obj instanceof NodeList) {
            DOMStreamer streamer = (DOMStreamer)SerializerPool.getInstance().borrowObject(DOMStreamer.class);
            try {
                MemTreeBuilder builder = new MemTreeBuilder();
                builder.startDocument();
                DocumentBuilderReceiver receiver = new DocumentBuilderReceiver(builder);
                streamer.setContentHandler(receiver);
                ValueSequence seq = new ValueSequence();
                NodeList nl = (NodeList)obj;
                int last = builder.getDocument().getLastNode();
                for (int i = 0; i < nl.getLength(); ++i) {
                    Node n = nl.item(i);
                    streamer.serialize(n, false);
                    NodeImpl created = builder.getDocument().getNode(last + 1);
                    seq.add(created);
                    last = builder.getDocument().getLastNode();
                }
                ValueSequence i = seq;
                return i;
            }
            catch (SAXException e) {
                throw new XPathException("Failed to transform node into internal model: " + e.getMessage());
            }
            finally {
                SerializerPool.getInstance().returnObject(streamer);
            }
        }
        if (obj instanceof Object[]) {
            Object[] array;
            boolean createNodeSequence = true;
            for (Object arrayItem : array = (Object[])obj) {
                if (arrayItem instanceof NodeProxy) continue;
                createNodeSequence = false;
            }
            AbstractSequence seq = createNodeSequence ? new AVLTreeNodeSet() : new ValueSequence();
            for (Object arrayItem : array) {
                seq.add((Item)((Object)XPathUtil.javaObjectToXPath(arrayItem, context, expandChars)));
            }
            return seq;
        }
        return new JavaObjectValue(obj);
    }

    public static final int javaClassToXPath(Class<?> clazz) {
        if (clazz == String.class) {
            return 22;
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return 23;
        }
        if (clazz == Integer.class || clazz == Integer.TYPE || clazz == Long.class || clazz == Long.TYPE || clazz == Short.class || clazz == Short.TYPE || clazz == Byte.class || clazz == Byte.TYPE) {
            return 31;
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return 34;
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return 33;
        }
        if (clazz.isAssignableFrom(Node.class)) {
            return -1;
        }
        return 100;
    }

    public static final NodeProxy getNode(DBBroker broker, XMLResource xres) throws XPathException {
        DocumentImpl document;
        if (xres instanceof LocalXMLResource) {
            LocalXMLResource lres = (LocalXMLResource)xres;
            try {
                return lres.getNode();
            }
            catch (XMLDBException xe) {
                throw new XPathException("Failed to convert LocalXMLResource to node: " + xe.getMessage());
            }
        }
        try {
            document = broker.getCollection(XmldbURI.xmldbUriFor(xres.getParentCollection().getName())).getDocument(broker, XmldbURI.xmldbUriFor(xres.getDocumentId()));
        }
        catch (URISyntaxException xe) {
            throw new XPathException(xe);
        }
        catch (XMLDBException xe) {
            throw new XPathException("Failed to get document for RemoteXMLResource: " + xe.getMessage());
        }
        catch (PermissionDeniedException pde) {
            throw new XPathException("Failed to get document: " + pde.getMessage());
        }
        NodeId nodeId = broker.getBrokerPool().getNodeFactory().createFromString(((RemoteXMLResource)xres).getNodeId());
        return new NodeProxy(document, nodeId);
    }
}

