/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.text.NumberFormat;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.debuggee.Debuggee;
import org.exist.security.EffectiveSubject;
import org.exist.security.Permission;
import org.exist.security.PermissionDeniedException;
import org.exist.security.Subject;
import org.exist.source.DBSource;
import org.exist.source.FileSource;
import org.exist.source.Source;
import org.exist.source.StringSource;
import org.exist.storage.DBBroker;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.PathExpr;
import org.exist.xquery.StaticXQueryException;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.parser.XQueryLexer;
import org.exist.xquery.parser.XQueryParser;
import org.exist.xquery.parser.XQueryTreeParser;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.util.HTTPUtils;
import org.exist.xquery.value.Sequence;

public class XQuery {
    private static final Logger LOG = LogManager.getLogger(XQuery.class);

    public CompiledXQuery compile(DBBroker broker, XQueryContext context, String expression) throws XPathException, PermissionDeniedException {
        StringSource source = new StringSource(expression);
        try {
            return this.compile(broker, context, source);
        }
        catch (IOException ioe) {
            throw new XPathException(ioe.getMessage());
        }
    }

    public CompiledXQuery compile(DBBroker broker, XQueryContext context, Source source) throws XPathException, IOException, PermissionDeniedException {
        return this.compile(broker, context, source, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CompiledXQuery compile(DBBroker broker, XQueryContext context, Source source, boolean xpointer) throws XPathException, IOException, PermissionDeniedException {
        context.setSource(source);
        try (Reader reader = source.getReader();){
            CompiledXQuery compiledXQuery = this.compile(broker, context, reader, xpointer);
            return compiledXQuery;
        }
        catch (UnsupportedEncodingException e) {
            throw new XPathException(ErrorCodes.XQST0087, "unsupported encoding " + e.getMessage());
        }
    }

    private CompiledXQuery compile(DBBroker broker, XQueryContext context, Reader reader, boolean xpointer) throws XPathException, PermissionDeniedException {
        context.getSource().validate(broker.getCurrentSubject(), 4);
        long start = System.currentTimeMillis();
        XQueryLexer lexer = new XQueryLexer(context, reader);
        XQueryParser parser = new XQueryParser(lexer);
        XQueryTreeParser treeParser = new XQueryTreeParser(context);
        try {
            if (xpointer) {
                parser.xpointer();
            } else {
                parser.xpath();
            }
            if (parser.foundErrors()) {
                LOG.debug(parser.getErrorMessage());
                throw new StaticXQueryException(parser.getErrorMessage());
            }
            AST ast = parser.getAST();
            if (ast == null) {
                throw new XPathException("Unknown XQuery parser error: the parser returned an empty syntax tree.");
            }
            PathExpr expr = new PathExpr(context);
            if (xpointer) {
                treeParser.xpointer(ast, expr);
            } else {
                treeParser.xpath(ast, expr);
            }
            if (treeParser.foundErrors()) {
                throw new StaticXQueryException(ast.getLine(), ast.getColumn(), treeParser.getErrorMessage(), (Throwable)treeParser.getLastException());
            }
            context.getRootContext().resolveForwardReferences();
            context.analyzeAndOptimizeIfModulesChanged(expr);
            if (LOG.isDebugEnabled()) {
                if (context.getExpressionCount() < 150) {
                    LOG.debug("Query diagnostics:\n" + ExpressionDumper.dump(expr));
                } else {
                    LOG.debug("Query diagnostics:\n[skipped: more than 150 expressions]");
                }
            }
            if (LOG.isDebugEnabled()) {
                NumberFormat nf = NumberFormat.getNumberInstance();
                LOG.debug("Compilation took " + nf.format(System.currentTimeMillis() - start) + " ms");
            }
            return expr;
        }
        catch (RecognitionException e) {
            LOG.debug("Error compiling query: " + e.getMessage(), (Throwable)e);
            String msg = e.getMessage();
            if (msg.endsWith(", found 'null'")) {
                msg = msg.substring(0, msg.length() - ", found 'null'".length());
            }
            throw new StaticXQueryException(e.getLine(), e.getColumn(), msg);
        }
        catch (TokenStreamException e) {
            String es = e.toString();
            if (es.matches("^line \\d+:\\d+:.+")) {
                LOG.debug("Error compiling query: " + e.getMessage(), (Throwable)e);
                int line = Integer.parseInt(es.substring(5, es.indexOf(58)));
                String tmpColumn = es.substring(es.indexOf(58) + 1);
                int column = Integer.parseInt(tmpColumn.substring(0, tmpColumn.indexOf(58)));
                throw new StaticXQueryException(line, column, e.getMessage(), (Throwable)e);
            }
            LOG.debug("Error compiling query: " + e.getMessage(), (Throwable)e);
            throw new StaticXQueryException(e.getMessage(), (Throwable)e);
        }
    }

    public Sequence execute(DBBroker broker, CompiledXQuery expression, Sequence contextSequence) throws XPathException, PermissionDeniedException {
        return this.execute(broker, expression, contextSequence, null);
    }

    public Sequence execute(DBBroker broker, CompiledXQuery expression, Sequence contextSequence, Properties outputProperties) throws XPathException, PermissionDeniedException {
        XQueryContext context = expression.getContext();
        Sequence result = this.execute(broker, expression, contextSequence, outputProperties, true);
        HTTPUtils.addLastModifiedHeader(result, context);
        return result;
    }

    public Sequence execute(DBBroker broker, CompiledXQuery expression, Sequence contextSequence, boolean resetContext) throws XPathException, PermissionDeniedException {
        return this.execute(broker, expression, contextSequence, null, resetContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence execute(DBBroker broker, CompiledXQuery expression, Sequence contextSequence, Properties outputProperties, boolean resetContext) throws XPathException, PermissionDeniedException {
        Debuggee debuggee;
        expression.getContext().getSource().validate(broker.getCurrentSubject(), 1);
        long start = System.currentTimeMillis();
        XQueryContext context = expression.getContext();
        expression.reset();
        if (resetContext) {
            context.getWatchDog().reset();
        }
        if (context.requireDebugMode() && (debuggee = broker.getBrokerPool().getDebuggee()) != null) {
            debuggee.joint(expression);
        }
        context.prepareForExecution();
        Subject callingUser = broker.getCurrentSubject();
        EffectiveSubject effectiveSubject = null;
        Source src = expression.getContext().getSource();
        if (src instanceof DBSource) {
            DBSource dbSrc = (DBSource)src;
            Permission perm = dbSrc.getPermissions();
            if (perm.isSetUid()) {
                effectiveSubject = perm.isSetGid() ? new EffectiveSubject(perm.getOwner(), perm.getGroup()) : new EffectiveSubject(perm.getOwner());
            } else if (perm.isSetGid()) {
                effectiveSubject = new EffectiveSubject(callingUser, perm.getGroup());
            }
        }
        try {
            if (effectiveSubject != null) {
                broker.pushSubject(effectiveSubject);
            }
            context.getProfiler().traceQueryStart();
            broker.getBrokerPool().getProcessMonitor().queryStarted(context.getWatchDog());
            try {
                if (contextSequence == null && context.getContextItemDeclartion() != null) {
                    contextSequence = context.getContextItemDeclartion().eval(null, null);
                }
                Sequence result = expression.eval(contextSequence);
                if (LOG.isDebugEnabled()) {
                    NumberFormat nf = NumberFormat.getNumberInstance();
                    LOG.debug("Execution took " + nf.format(System.currentTimeMillis() - start) + " ms");
                }
                if (outputProperties != null) {
                    context.checkOptions(outputProperties);
                }
                Sequence sequence = result;
                context.getProfiler().traceQueryEnd(context);
                broker.getBrokerPool().getProcessMonitor().queryCompleted(context.getWatchDog());
                expression.reset();
                if (resetContext) {
                    context.reset();
                }
                return sequence;
            }
            catch (Throwable throwable) {
                context.getProfiler().traceQueryEnd(context);
                broker.getBrokerPool().getProcessMonitor().queryCompleted(context.getWatchDog());
                expression.reset();
                if (resetContext) {
                    context.reset();
                }
                throw throwable;
            }
        }
        finally {
            if (effectiveSubject != null) {
                broker.popSubject();
            }
        }
    }

    public Sequence execute(DBBroker broker, String expression, Sequence contextSequence) throws XPathException, PermissionDeniedException {
        XQueryContext context = new XQueryContext(broker.getBrokerPool());
        CompiledXQuery compiled = this.compile(broker, context, expression);
        return this.execute(broker, compiled, contextSequence);
    }

    public Sequence execute(DBBroker broker, File file, Sequence contextSequence) throws XPathException, IOException, PermissionDeniedException {
        XQueryContext context = new XQueryContext(broker.getBrokerPool());
        CompiledXQuery compiled = this.compile(broker, context, new FileSource(file.toPath(), true));
        return this.execute(broker, compiled, contextSequence);
    }
}

