/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.array;

import java.util.ArrayList;
import java.util.List;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.array.ArrayType;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class ArrayConstructor
extends AbstractExpression {
    private ConstructorType type;
    private List<Expression> arguments = new ArrayList<Expression>();

    public ArrayConstructor(XQueryContext context, ConstructorType type) {
        super(context);
        this.type = type;
    }

    public void addArgument(Expression expression) {
        this.arguments.add(expression);
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        for (Expression expr : this.arguments) {
            expr.analyze(contextInfo);
        }
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getXQueryVersion() < 31) {
            throw new XPathException((Expression)this, ErrorCodes.EXXQDY0004, "arrays are only available in XQuery 3.1, but version declaration states " + this.context.getXQueryVersion());
        }
        switch (this.type) {
            case SQUARE_ARRAY: {
                ArrayList<Sequence> items = new ArrayList<Sequence>(this.arguments.size());
                for (Expression arg : this.arguments) {
                    Sequence result = arg.eval(contextSequence, contextItem);
                    if (result == null) continue;
                    items.add(result);
                }
                return new ArrayType(this.context, items);
            }
        }
        Sequence result = this.arguments.get(0).eval(contextSequence, contextItem);
        return new ArrayType(this.context, result);
    }

    @Override
    public int returnsType() {
        return 103;
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        for (Expression expr : this.arguments) {
            expr.resetState(postOptimization);
        }
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        dumper.display("array {");
        dumper.display('}');
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        for (Expression expr : this.arguments) {
            expr.accept(visitor);
        }
    }

    public static enum ConstructorType {
        SQUARE_ARRAY,
        CURLY_ARRAY;

    }
}

