/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.array;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.exist.dom.QName;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.array.ArrayType;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReference;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.ValueSequence;

public class ArrayFunction
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName(Fn.access$000(Fn.SIZE), "http://www.w3.org/2005/xpath-functions/array", "array"), "Returns the number of members in the supplied array.", new SequenceType[]{new FunctionParameterSequenceType("array", 103, 2, "The array")}, new FunctionReturnSequenceType(31, 2, "The number of members in the supplied array")), new FunctionSignature(new QName(Fn.access$000(Fn.GET), "http://www.w3.org/2005/xpath-functions/array", "array"), "Gets the value at the specified position in the supplied array (counting from 1). This is the same as calling $array($index).", new SequenceType[]{new FunctionParameterSequenceType("array", 103, 2, "The array"), new FunctionParameterSequenceType("index", 31, 2, "The index")}, new FunctionReturnSequenceType(31, 7, "The value at $index")), new FunctionSignature(new QName(Fn.access$000(Fn.APPEND), "http://www.w3.org/2005/xpath-functions/array", "array"), "Returns an array containing all the members of the supplied array, plus one additionalmember at the end.", new SequenceType[]{new FunctionParameterSequenceType("array", 103, 2, "The array"), new FunctionParameterSequenceType("appendage", 11, 7, "The items to append")}, new FunctionReturnSequenceType(103, 7, "A copy of $array with the new member attached")), new FunctionSignature(new QName(Fn.access$000(Fn.HEAD), "http://www.w3.org/2005/xpath-functions/array", "array"), "Returns the first member of an array, i.e. $array(1)", new SequenceType[]{new FunctionParameterSequenceType("array", 103, 2, "The array")}, new FunctionReturnSequenceType(11, 7, "The first member of the array")), new FunctionSignature(new QName(Fn.access$000(Fn.TAIL), "http://www.w3.org/2005/xpath-functions/array", "array"), "Returns an array containing all members except the first from a supplied array.", new SequenceType[]{new FunctionParameterSequenceType("array", 103, 2, "The array")}, new FunctionReturnSequenceType(103, 2, "A new array containing all members except the first")), new FunctionSignature(new QName(Fn.access$000(Fn.SUBARRAY), "http://www.w3.org/2005/xpath-functions/array", "array"), "Gets an array containing all members from a supplied array starting at a supplied position, up to the end of the array", new SequenceType[]{new FunctionParameterSequenceType("array", 103, 2, "The array"), new FunctionParameterSequenceType("start", 31, 2, "The start index")}, new FunctionReturnSequenceType(103, 2, "A new array containing all members from $start")), new FunctionSignature(new QName(Fn.access$000(Fn.SUBARRAY), "http://www.w3.org/2005/xpath-functions/array", "array"), "Gets an array containing all members from a supplied array starting at a supplied position, up to a specified length.", new SequenceType[]{new FunctionParameterSequenceType("array", 103, 2, "The array"), new FunctionParameterSequenceType("start", 31, 2, "The start index"), new FunctionParameterSequenceType("length", 31, 2, "Length of the subarray")}, new FunctionReturnSequenceType(103, 2, "A new array containing all members from $start up to the specified length")), new FunctionSignature(new QName(Fn.access$000(Fn.REMOVE), "http://www.w3.org/2005/xpath-functions/array", "array"), "Returns an array containing all members from $array except the member whose position is $position.", new SequenceType[]{new FunctionParameterSequenceType("array", 103, 2, "The array"), new FunctionParameterSequenceType("position", 31, 2, "Position of the member to remove")}, new FunctionReturnSequenceType(103, 2, "A new array containing all members except the one at $position")), new FunctionSignature(new QName(Fn.access$000(Fn.INSERT_BEFORE), "http://www.w3.org/2005/xpath-functions/array", "array"), "Returns an array containing all the members of the supplied array, with one additional member at a specified position.", new SequenceType[]{new FunctionParameterSequenceType("array", 103, 2, "The array"), new FunctionParameterSequenceType("position", 31, 2, "Position at which the new member is inserted"), new FunctionParameterSequenceType("member", 11, 7, "The member to insert")}, new FunctionReturnSequenceType(103, 2, "A new array containing all members plus the new member")), new FunctionSignature(new QName(Fn.access$000(Fn.REVERSE), "http://www.w3.org/2005/xpath-functions/array", "array"), "Returns an array containing all the members of the supplied array, but in reverse order.", new SequenceType[]{new FunctionParameterSequenceType("array", 103, 2, "The array")}, new FunctionReturnSequenceType(103, 2, "The array in reverse order")), new FunctionSignature(new QName(Fn.access$000(Fn.JOIN), "http://www.w3.org/2005/xpath-functions/array", "array"), "Concatenates the contents of several arrays into a single array", new SequenceType[]{new FunctionParameterSequenceType("arrays", 103, 7, "The arrays to join")}, new FunctionReturnSequenceType(103, 2, "The resulting array")), new FunctionSignature(new QName(Fn.access$000(Fn.FOR_EACH), "http://www.w3.org/2005/xpath-functions/array", "array"), "Returns an array whose size is the same as array:size($array), in which each member is computed by applying $function to the corresponding member of $array.", new SequenceType[]{new FunctionParameterSequenceType("array", 103, 2, "The array to process"), new FunctionParameterSequenceType("function", 101, 2, "The function called on each member of the array")}, new FunctionReturnSequenceType(103, 2, "The resulting array")), new FunctionSignature(new QName(Fn.access$000(Fn.FILTER), "http://www.w3.org/2005/xpath-functions/array", "array"), "Returns an array containing those members of the $array for which $function returns true.", new SequenceType[]{new FunctionParameterSequenceType("array", 103, 2, "The array to process"), new FunctionParameterSequenceType("function", 101, 2, "The function called on each member of the array")}, new FunctionReturnSequenceType(103, 2, "The resulting array")), new FunctionSignature(new QName(Fn.access$000(Fn.FOLD_LEFT), "http://www.w3.org/2005/xpath-functions/array", "array"), "Evaluates the supplied function cumulatively on successive values of the supplied array.", new SequenceType[]{new FunctionParameterSequenceType("array", 103, 2, "The array to process"), new FunctionParameterSequenceType("zero", 11, 7, "Start value"), new FunctionParameterSequenceType("function", 101, 2, "The function to call")}, new FunctionReturnSequenceType(11, 7, "The result of the cumulative function call")), new FunctionSignature(new QName(Fn.access$000(Fn.FOLD_RIGHT), "http://www.w3.org/2005/xpath-functions/array", "array"), "Evaluates the supplied function cumulatively on successive values of the supplied array.", new SequenceType[]{new FunctionParameterSequenceType("array", 103, 2, "The array to process"), new FunctionParameterSequenceType("zero", 11, 7, "Start value"), new FunctionParameterSequenceType("function", 101, 2, "The function to call")}, new FunctionReturnSequenceType(11, 7, "The result of the cumulative function call")), new FunctionSignature(new QName(Fn.access$000(Fn.FOR_EACH_PAIR), "http://www.w3.org/2005/xpath-functions/array", "array"), "Returns an array obtained by evaluating the supplied function once for each pair of members at the same position in the two supplied arrays.", new SequenceType[]{new FunctionParameterSequenceType("array1", 103, 2, "The first array to process"), new FunctionParameterSequenceType("array2", 103, 2, "The second array to process"), new FunctionParameterSequenceType("function", 101, 2, "The function to call for each pair")}, new FunctionReturnSequenceType(103, 2, "The resulting array")), new FunctionSignature(new QName(Fn.access$000(Fn.FLATTEN), "http://www.w3.org/2005/xpath-functions/array", "array"), "Replaces an array appearing in a supplied sequence with the members of the array, recursively.", new SequenceType[]{new FunctionParameterSequenceType("input", 11, 7, "The sequence to flatten")}, new FunctionReturnSequenceType(11, 7, "The resulting sequence"))};
    private AnalyzeContextInfo cachedContextInfo;

    public ArrayFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        this.cachedContextInfo = new AnalyzeContextInfo(contextInfo);
        super.analyze(contextInfo);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (this.context.getXQueryVersion() < 31) {
            throw new XPathException((Expression)this, ErrorCodes.EXXQDY0004, "arrays are only available in XQuery 3.1, but version declaration states " + this.context.getXQueryVersion());
        }
        Fn called = Fn.get(this.getSignature().getName().getLocalPart());
        switch (called) {
            case JOIN: {
                ArrayList<ArrayType> arrays = new ArrayList<ArrayType>(args[0].getItemCount());
                SequenceIterator i = args[0].iterate();
                while (i.hasNext()) {
                    arrays.add((ArrayType)i.nextItem());
                }
                return ArrayType.join(this.context, arrays);
            }
            case FLATTEN: {
                ValueSequence result = new ValueSequence(args[0].getItemCount());
                ArrayType.flatten(args[0], result);
                return result;
            }
        }
        ArrayType array = (ArrayType)args[0].itemAt(0);
        switch (called) {
            case SIZE: {
                return new IntegerValue(array.getSize());
            }
            case GET: {
                IntegerValue index = (IntegerValue)args[1].itemAt(0);
                return array.get(index.getInt() - 1);
            }
            case APPEND: {
                return array.append(args[1]);
            }
            case HEAD: {
                if (array.getSize() == 0) {
                    throw new XPathException((Expression)this, ErrorCodes.FOAY0001, "Array is empty");
                }
                return array.get(0);
            }
            case TAIL: {
                if (array.getSize() == 0) {
                    throw new XPathException((Expression)this, ErrorCodes.FOAY0001, "Array is empty");
                }
                return array.tail();
            }
            case SUBARRAY: {
                int start = ((IntegerValue)args[1].itemAt(0)).getInt();
                int end = array.getSize();
                if (this.getArgumentCount() == 3) {
                    int length = ((IntegerValue)args[2].itemAt(0)).getInt();
                    if (start + length > array.getSize() + 1) {
                        throw new XPathException((Expression)this, ErrorCodes.FOAY0001, "Array index out of bounds: " + (start + length - 1));
                    }
                    if (length < 0) {
                        throw new XPathException((Expression)this, ErrorCodes.FOAY0002, "Specified length < 0");
                    }
                    end = start + length - 1;
                }
                if (start < 1) {
                    throw new XPathException((Expression)this, ErrorCodes.FOAY0001, "Start index into array is < 1");
                }
                return array.subarray(start - 1, end);
            }
            case REMOVE: {
                int rpos = ((IntegerValue)args[1].itemAt(0)).getInt();
                if (rpos < 1 || rpos > array.getSize()) {
                    throw new XPathException((Expression)this, ErrorCodes.FOAY0001, "Index of item to remove (" + rpos + ") is out of bounds");
                }
                return array.remove(rpos - 1);
            }
            case INSERT_BEFORE: {
                int ipos = ((IntegerValue)args[1].itemAt(0)).getInt();
                if (ipos < 1 || ipos > array.getSize() + 1) {
                    throw new XPathException((Expression)this, ErrorCodes.FOAY0001, "Index of item to insert (" + ipos + ") is out of bounds");
                }
                return array.insertBefore(ipos - 1, args[2]);
            }
            case REVERSE: {
                return array.reverse();
            }
            case FOR_EACH: {
                return array.forEach(this.getFunction(args[1]));
            }
            case FILTER: {
                return array.filter(this.getFunction(args[1]));
            }
            case FOLD_LEFT: {
                return array.foldLeft(this.getFunction(args[2]), args[1]);
            }
            case FOLD_RIGHT: {
                return array.foldRight(this.getFunction(args[2]), args[1]);
            }
            case FOR_EACH_PAIR: {
                return array.forEachPair((ArrayType)args[1].itemAt(0), this.getFunction(args[2]));
            }
        }
        throw new XPathException((Expression)this, "Unknown function: " + this.getName());
    }

    private FunctionReference getFunction(Sequence arg) throws XPathException {
        FunctionReference ref = (FunctionReference)arg.itemAt(0);
        ref.analyze(this.cachedContextInfo);
        return ref;
    }

    private static enum Fn {
        SIZE("size"),
        GET("get"),
        APPEND("append"),
        HEAD("head"),
        TAIL("tail"),
        SUBARRAY("subarray"),
        REMOVE("remove"),
        INSERT_BEFORE("insert-before"),
        REVERSE("reverse"),
        JOIN("join"),
        FOR_EACH("for-each"),
        FILTER("filter"),
        FOLD_LEFT("fold-left"),
        FOLD_RIGHT("fold-right"),
        FOR_EACH_PAIR("for-each-pair"),
        FLATTEN("flatten");

        static final Map<String, Fn> fnMap;
        private final String fname;

        static Fn get(String name) {
            return fnMap.get(name);
        }

        private Fn(String name) {
            this.fname = name;
        }

        static /* synthetic */ String access$000(Fn x0) {
            return x0.fname;
        }

        static {
            fnMap = new HashMap<String, Fn>();
            for (Fn fn : Fn.values()) {
                fnMap.put(fn.fname, fn);
            }
        }
    }
}

