/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.array;

import com.github.krukow.clj_lang.IPersistentVector;
import com.github.krukow.clj_lang.ISeq;
import com.github.krukow.clj_lang.PersistentVector;
import com.github.krukow.clj_lang.RT;
import java.util.ArrayList;
import java.util.List;
import org.exist.dom.QName;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.InternalFunctionCall;
import org.exist.xquery.Lookup;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReference;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public class ArrayType
extends FunctionReference
implements Lookup.LookupSupport {
    private static final FunctionSignature ACCESSOR = new FunctionSignature(new QName("get", "http://www.w3.org/2005/xpath-functions/array", "array"), "Internal accessor function for arrays.", new SequenceType[]{new FunctionParameterSequenceType("n", 46, 2, "the position of the item to retrieve from the array")}, new SequenceType(11, 7));
    private InternalFunctionCall accessorFunc;
    private IPersistentVector<Sequence> vector;
    private XQueryContext context;

    public ArrayType(XQueryContext context, List<Sequence> items) {
        this(context);
        this.vector = PersistentVector.create(items);
    }

    public ArrayType(XQueryContext context, Sequence items) throws XPathException {
        this(context);
        ArrayList<Sequence> itemList = new ArrayList<Sequence>(items.getItemCount());
        SequenceIterator i = items.iterate();
        while (i.hasNext()) {
            itemList.add(i.nextItem().toSequence());
        }
        this.vector = PersistentVector.create(itemList);
    }

    public ArrayType(XQueryContext context, IPersistentVector<Sequence> vector) {
        this(context);
        this.vector = vector;
    }

    private ArrayType(XQueryContext context) {
        super(null);
        this.context = context;
        AccessorFunc fn = new AccessorFunc(context);
        this.accessorFunc = new InternalFunctionCall(fn);
    }

    public Sequence get(int n) {
        return (Sequence)this.vector.nth(n);
    }

    @Override
    public Sequence get(AtomicValue key) throws XPathException {
        if (!Type.subTypeOf(key.getType(), 31)) {
            throw new XPathException(ErrorCodes.XPTY0004, "position argument for array lookup must be a positive integer");
        }
        int pos = ((IntegerValue)key).getInt();
        if (pos <= 0 || pos > this.getSize()) {
            throw new XPathException(ErrorCodes.XPTY0004, "position argument for array lookup must be > 0 and < array:size");
        }
        return this.get(pos - 1);
    }

    @Override
    public Sequence keys() throws XPathException {
        return this.asSequence();
    }

    @Override
    public Sequence tail() throws XPathException {
        if (this.vector.length() == 2) {
            Sequence tail = (Sequence)this.vector.nth(1);
            return new ArrayType(this.context, tail);
        }
        return new ArrayType(this.context, (IPersistentVector<Sequence>)RT.subvec(this.vector, (int)1, (int)this.vector.length()));
    }

    public ArrayType subarray(int start, int end) throws XPathException {
        return new ArrayType(this.context, (IPersistentVector<Sequence>)RT.subvec(this.vector, (int)start, (int)end));
    }

    public ArrayType remove(int position) throws XPathException {
        PersistentVector.TransientVector ret = PersistentVector.emptyVector().asTransient();
        for (int i = 0; i < this.vector.length(); ++i) {
            if (position == i) continue;
            ret = ret.conj(this.vector.nth(i));
        }
        return new ArrayType(this.context, (IPersistentVector<Sequence>)((IPersistentVector)ret.persistent()));
    }

    public ArrayType insertBefore(int position, Sequence member) throws XPathException {
        PersistentVector.TransientVector ret = PersistentVector.emptyVector().asTransient();
        for (int i = 0; i < this.vector.length(); ++i) {
            if (position == i) {
                ret = ret.conj((Object)member);
            }
            ret = ret.conj(this.vector.nth(i));
        }
        if (position == this.vector.length()) {
            ret = ret.conj((Object)member);
        }
        return new ArrayType(this.context, (IPersistentVector<Sequence>)((IPersistentVector)ret.persistent()));
    }

    public static ArrayType join(XQueryContext context, List<ArrayType> arrays) {
        PersistentVector.TransientVector ret = PersistentVector.emptyVector().asTransient();
        for (ArrayType type : arrays) {
            for (ISeq seq = type.vector.seq(); seq != null; seq = seq.next()) {
                ret.conj(seq.first());
            }
        }
        return new ArrayType(context, (IPersistentVector<Sequence>)((IPersistentVector)ret.persistent()));
    }

    public void add(Sequence seq) {
        this.vector = this.vector.cons((Object)seq);
    }

    public ArrayType append(Sequence seq) {
        return new ArrayType(this.context, (IPersistentVector<Sequence>)this.vector.cons((Object)seq));
    }

    public ArrayType reverse() {
        PersistentVector rvec = PersistentVector.create((ISeq)this.vector.rseq());
        return new ArrayType(this.context, (IPersistentVector<Sequence>)rvec);
    }

    public Sequence asSequence() throws XPathException {
        ValueSequence result = new ValueSequence(this.vector.length());
        for (int i = 0; i < this.vector.length(); ++i) {
            result.addAll((Sequence)this.vector.nth(i));
        }
        return result;
    }

    public Sequence[] toArray() {
        Object[] array = new Sequence[this.vector.length()];
        return (Sequence[])RT.seqToPassedArray((ISeq)this.vector.seq(), (Object[])array);
    }

    public int getSize() {
        return this.vector.length();
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        this.accessorFunc.analyze(contextInfo);
    }

    @Override
    public Sequence eval(Sequence contextSequence) throws XPathException {
        return this.accessorFunc.eval(contextSequence);
    }

    @Override
    public void setArguments(List<Expression> arguments) throws XPathException {
        this.accessorFunc.setArguments(arguments);
    }

    @Override
    public void resetState(boolean postOptimization) {
        this.accessorFunc.resetState(postOptimization);
    }

    @Override
    public int getType() {
        return 103;
    }

    @Override
    public int getItemType() {
        return 103;
    }

    @Override
    public AtomicValue atomize() throws XPathException {
        if (this.vector.length() == 0) {
            return null;
        }
        if (this.vector.length() > 1) {
            throw new XPathException(ErrorCodes.XPTY0004, "Expected single atomic value but found array with length " + this.vector.length());
        }
        Sequence member = (Sequence)this.vector.nth(0);
        if (member.hasMany()) {
            throw new XPathException(ErrorCodes.XPTY0004, "Expected single atomic value but found sequence of length " + member.getItemCount());
        }
        return member.itemAt(0).atomize();
    }

    public ArrayType forEach(FunctionReference ref) throws XPathException {
        PersistentVector.TransientVector ret = PersistentVector.emptyVector().asTransient();
        Sequence[] fargs = new Sequence[1];
        for (ISeq seq = this.vector.seq(); seq != null; seq = seq.next()) {
            fargs[0] = (Sequence)seq.first();
            ret.conj((Object)ref.evalFunction(null, null, fargs));
        }
        return new ArrayType(this.context, (IPersistentVector<Sequence>)((IPersistentVector)ret.persistent()));
    }

    public ArrayType forEachPair(ArrayType other, FunctionReference ref) throws XPathException {
        PersistentVector.TransientVector ret = PersistentVector.emptyVector().asTransient();
        ISeq i1 = this.vector.seq();
        for (ISeq i2 = other.vector.seq(); i1 != null && i2 != null; i1 = i1.next(), i2 = i2.next()) {
            ret.conj((Object)ref.evalFunction(null, null, new Sequence[]{(Sequence)i1.first(), (Sequence)i2.first()}));
        }
        return new ArrayType(this.context, (IPersistentVector<Sequence>)((IPersistentVector)ret.persistent()));
    }

    public ArrayType filter(FunctionReference ref) throws XPathException {
        PersistentVector.TransientVector ret = PersistentVector.emptyVector().asTransient();
        Sequence[] fargs = new Sequence[1];
        for (ISeq seq = this.vector.seq(); seq != null; seq = seq.next()) {
            fargs[0] = (Sequence)seq.first();
            Sequence fret = ref.evalFunction(null, null, fargs);
            if (!fret.effectiveBooleanValue()) continue;
            ret.conj((Object)fargs[0]);
        }
        return new ArrayType(this.context, (IPersistentVector<Sequence>)((IPersistentVector)ret.persistent()));
    }

    public Sequence foldLeft(FunctionReference ref, Sequence zero) throws XPathException {
        for (ISeq seq = this.vector.seq(); seq != null; seq = seq.next()) {
            zero = ref.evalFunction(null, null, new Sequence[]{zero, (Sequence)seq.first()});
        }
        return zero;
    }

    public Sequence foldRight(FunctionReference ref, Sequence zero) throws XPathException {
        ISeq seq = this.vector.seq();
        return this.foldRight(ref, zero, (ISeq<Sequence>)seq);
    }

    private Sequence foldRight(FunctionReference ref, Sequence zero, ISeq<Sequence> seq) throws XPathException {
        if (seq == null) {
            return zero;
        }
        Sequence head = (Sequence)seq.first();
        Sequence tailResult = this.foldRight(ref, zero, (ISeq<Sequence>)seq.next());
        return ref.evalFunction(null, null, new Sequence[]{head, tailResult});
    }

    protected static Sequence flatten(Sequence input, ValueSequence result) throws XPathException {
        SequenceIterator i = input.iterate();
        while (i.hasNext()) {
            Item item = i.nextItem();
            if (item.getType() == 103) {
                Sequence members = ((ArrayType)item).asSequence();
                ArrayType.flatten(members, result);
                continue;
            }
            result.add(item);
        }
        return result;
    }

    public static Sequence flatten(Item item) throws XPathException {
        if (item.getType() == 103) {
            Sequence members = ((ArrayType)item).asSequence();
            return ArrayType.flatten(members, new ValueSequence(members.getItemCount()));
        }
        return item.toSequence();
    }

    public static Sequence flatten(Sequence input) throws XPathException {
        if (input.hasOne()) {
            return ArrayType.flatten(input.itemAt(0));
        }
        boolean flatten = false;
        int itemType = input.getItemType();
        if (itemType == 103) {
            flatten = true;
        } else if (itemType == 11) {
            SequenceIterator i = input.iterate();
            while (i.hasNext()) {
                if (i.nextItem().getType() != 103) continue;
                flatten = true;
                break;
            }
        }
        return flatten ? ArrayType.flatten(input, new ValueSequence(input.getItemCount() * 2)) : input;
    }

    private class AccessorFunc
    extends BasicFunction {
        public AccessorFunc(XQueryContext context) {
            super(context, ACCESSOR);
        }

        @Override
        public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
            IntegerValue v = (IntegerValue)args[0].itemAt(0);
            int n = v.getInt();
            if (n <= 0 || n > ArrayType.this.getSize()) {
                throw new XPathException((Expression)this, ErrorCodes.FOAY0001, "Position " + n + " does not exist in this array. Length is " + ArrayType.this.getSize());
            }
            return ArrayType.this.get(n - 1);
        }
    }
}

