/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import java.util.Calendar;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.NumberFormatter;
import org.exist.xquery.value.AbstractDateTimeValue;
import org.exist.xquery.value.DayTimeDurationValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;

public class FnFormatDates
extends BasicFunction {
    private static final String DEFAULT_LANGUAGE = Locale.getDefault().getLanguage();
    private static FunctionParameterSequenceType DATETIME = new FunctionParameterSequenceType("value", 50, 3, "The datetime");
    private static FunctionParameterSequenceType DATE = new FunctionParameterSequenceType("value", 51, 3, "The date");
    private static FunctionParameterSequenceType TIME = new FunctionParameterSequenceType("value", 52, 3, "The time");
    private static FunctionParameterSequenceType PICTURE = new FunctionParameterSequenceType("picture", 22, 2, "The picture string");
    private static FunctionParameterSequenceType LANGUAGE = new FunctionParameterSequenceType("language", 22, 3, "The language string");
    private static FunctionParameterSequenceType CALENDAR = new FunctionParameterSequenceType("calendar", 22, 3, "The calendar string");
    private static FunctionParameterSequenceType PLACE = new FunctionParameterSequenceType("place", 22, 3, "The place string");
    private static FunctionReturnSequenceType RETURN = new FunctionReturnSequenceType(22, 2, "The formatted date");
    public static final FunctionSignature FNS_FORMAT_DATETIME_2 = new FunctionSignature(new QName("format-dateTime", "http://www.w3.org/2005/xpath-functions"), "Returns a string containing an xs:date value formatted for display.", new SequenceType[]{DATETIME, PICTURE}, RETURN);
    public static final FunctionSignature FNS_FORMAT_DATETIME_5 = new FunctionSignature(new QName("format-dateTime", "http://www.w3.org/2005/xpath-functions"), "Returns a string containing an xs:date value formatted for display.", new SequenceType[]{DATETIME, PICTURE, LANGUAGE, CALENDAR, PLACE}, RETURN);
    public static final FunctionSignature FNS_FORMAT_DATE_2 = new FunctionSignature(new QName("format-date", "http://www.w3.org/2005/xpath-functions"), "Returns a string containing an xs:date value formatted for display.", new SequenceType[]{DATE, PICTURE}, RETURN);
    public static final FunctionSignature FNS_FORMAT_DATE_5 = new FunctionSignature(new QName("format-date", "http://www.w3.org/2005/xpath-functions"), "Returns a string containing an xs:date value formatted for display.", new SequenceType[]{DATE, PICTURE, LANGUAGE, CALENDAR, PLACE}, RETURN);
    public static final FunctionSignature FNS_FORMAT_TIME_2 = new FunctionSignature(new QName("format-time", "http://www.w3.org/2005/xpath-functions"), "Returns a string containing an xs:time value formatted for display.", new SequenceType[]{TIME, PICTURE}, RETURN);
    public static final FunctionSignature FNS_FORMAT_TIME_5 = new FunctionSignature(new QName("format-time", "http://www.w3.org/2005/xpath-functions"), "Returns a string containing an xs:time value formatted for display.", new SequenceType[]{TIME, PICTURE, LANGUAGE, CALENDAR, PLACE}, RETURN);
    private static Pattern componentPattern = Pattern.compile("([YMDdWwFHhmsfZzPCE])\\s*(.*)");
    private static final char[] MILITARY_TZ_CHARS = new char[]{'Z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y'};

    public FnFormatDates(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Optional<String> place;
        Optional<String> language;
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        AbstractDateTimeValue value = (AbstractDateTimeValue)args[0].itemAt(0);
        String picture = args[1].getStringValue();
        if (this.getArgumentCount() == 5) {
            language = args[2].hasOne() ? Optional.of(args[2].getStringValue()) : Optional.empty();
            place = args[4].hasOne() ? Optional.of(args[4].getStringValue()) : Optional.empty();
        } else {
            language = Optional.empty();
            place = Optional.empty();
        }
        return new StringValue(this.formatDate(picture, value, language, place));
    }

    private String formatDate(String pic, AbstractDateTimeValue dt, Optional<String> language, Optional<String> place) throws XPathException {
        boolean tzHMZNPictureHint = pic.equals("[H00]:[M00] [ZN]");
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (true) {
            int close;
            if (i < pic.length() && pic.charAt(i) != '[') {
                sb.append(pic.charAt(i));
                if (pic.charAt(i) == ']' && (++i == pic.length() || pic.charAt(i) != ']')) {
                    throw new XPathException((Expression)this, ErrorCodes.FOFD1340, "Closing ']' in date picture must be written as ']]'");
                }
                ++i;
                continue;
            }
            if (i == pic.length()) break;
            if (++i < pic.length() && pic.charAt(i) == '[') {
                sb.append('[');
                ++i;
                continue;
            }
            int n = close = i < pic.length() ? pic.indexOf("]", i) : -1;
            if (close == -1) {
                throw new XPathException((Expression)this, ErrorCodes.FOFD1340, "Date format contains a '[' with no matching ']'");
            }
            String component = pic.substring(i, close);
            this.formatComponent(component, dt, language, place, tzHMZNPictureHint, sb);
            i = close + 1;
        }
        return sb.toString();
    }

    private void formatComponent(String component, AbstractDateTimeValue dt, Optional<String> language, Optional<String> place, boolean tzHMZNPictureHint, StringBuilder sb) throws XPathException {
        Matcher matcher = componentPattern.matcher(component);
        if (!matcher.matches()) {
            throw new XPathException((Expression)this, ErrorCodes.FOFD1340, "Unrecognized date/time component: " + component);
        }
        char specifier = component.charAt(0);
        String width = null;
        String picture = matcher.group(2);
        int widthSep = picture.indexOf(44);
        if (-1 < widthSep) {
            width = picture.substring(widthSep + 1);
            picture = picture.substring(0, widthSep);
        }
        if (picture == null || picture.length() == 0) {
            picture = this.getDefaultFormat(specifier);
        }
        boolean allowDate = !Type.subTypeOf(dt.getType(), 52);
        boolean allowTime = !Type.subTypeOf(dt.getType(), 51);
        switch (specifier) {
            case 'Y': {
                if (allowDate) {
                    int year = dt.getPart(0);
                    this.formatNumber(specifier, picture, width, year, language, sb);
                    break;
                }
                throw new XPathException((Expression)this, ErrorCodes.FOFD1350, "format-time does not support a year component");
            }
            case 'M': {
                if (!tzHMZNPictureHint) {
                    if (allowDate) {
                        int month = dt.getPart(1);
                        this.formatNumber(specifier, picture, width, month, language, sb);
                        break;
                    }
                    throw new XPathException((Expression)this, ErrorCodes.FOFD1350, "format-time does not support a month component");
                }
                if (allowTime) {
                    int minute = dt.getPart(4);
                    this.formatNumber(specifier, picture, width, minute, language, sb);
                    break;
                }
                throw new XPathException((Expression)this, ErrorCodes.FOFD1350, "format-date does not support a minute component");
            }
            case 'D': {
                if (allowDate) {
                    int day = dt.getPart(2);
                    this.formatNumber(specifier, picture, width, day, language, sb);
                    break;
                }
                throw new XPathException((Expression)this, ErrorCodes.FOFD1350, "format-time does not support a day component");
            }
            case 'd': {
                if (allowDate) {
                    int dayInYear = dt.getDayWithinYear();
                    this.formatNumber(specifier, picture, width, dayInYear, language, sb);
                    break;
                }
                throw new XPathException((Expression)this, ErrorCodes.FOFD1350, "format-time does not support a day component");
            }
            case 'W': {
                if (allowDate) {
                    int week = dt.getWeekWithinYear();
                    this.formatNumber(specifier, picture, width, week, language, sb);
                    break;
                }
                throw new XPathException((Expression)this, ErrorCodes.FOFD1350, "format-time does not support a week component");
            }
            case 'w': {
                if (allowDate) {
                    int week = dt.getWeekWithinMonth();
                    this.formatNumber(specifier, picture, width, week, language, sb);
                    break;
                }
                throw new XPathException((Expression)this, ErrorCodes.FOFD1350, "format-time does not support a week component");
            }
            case 'F': {
                if (allowDate) {
                    int day = dt.getDayOfWeek();
                    this.formatNumber(specifier, picture, width, day, language, sb);
                    break;
                }
                throw new XPathException((Expression)this, ErrorCodes.FOFD1350, "format-time does not support a day component");
            }
            case 'H': {
                if (allowTime) {
                    int hour = dt.getPart(3);
                    this.formatNumber(specifier, picture, width, hour, language, sb);
                    break;
                }
                throw new XPathException((Expression)this, ErrorCodes.FOFD1350, "format-date does not support a hour component");
            }
            case 'h': {
                if (allowTime) {
                    int hour = dt.getPart(3) % 12;
                    if (hour == 0) {
                        hour = 12;
                    }
                    this.formatNumber(specifier, picture, width, hour, language, sb);
                    break;
                }
                throw new XPathException((Expression)this, ErrorCodes.FOFD1350, "format-date does not support a hour component");
            }
            case 'm': {
                if (allowTime) {
                    int minute = dt.getPart(4);
                    this.formatNumber(specifier, picture, width, minute, language, sb);
                    break;
                }
                throw new XPathException((Expression)this, ErrorCodes.FOFD1350, "format-date does not support a minute component");
            }
            case 's': {
                if (allowTime) {
                    int second = dt.getPart(5);
                    this.formatNumber(specifier, picture, width, second, language, sb);
                    break;
                }
                throw new XPathException((Expression)this, ErrorCodes.FOFD1350, "format-date does not support a second component");
            }
            case 'f': {
                if (allowTime) {
                    int fraction = dt.getPart(6);
                    this.formatNumber(specifier, picture, width, fraction, language, sb);
                    break;
                }
                throw new XPathException((Expression)this, ErrorCodes.FOFD1350, "format-date does not support a fractional seconds component");
            }
            case 'P': {
                if (allowTime) {
                    int hour = dt.getPart(3);
                    this.formatNumber(specifier, picture, width, hour, language, sb);
                    break;
                }
                throw new XPathException((Expression)this, ErrorCodes.FOFD1350, "format-date does not support an am/pm component");
            }
            case 'z': {
                if (dt.getTimezone() != Sequence.EMPTY_SEQUENCE) {
                    sb.append("GMT");
                }
            }
            case 'Z': {
                Calendar cal = dt.toJavaObject(Calendar.class);
                Sequence tz = dt.getTimezone();
                if (tz == Sequence.EMPTY_SEQUENCE) break;
                DayTimeDurationValue dtv = (DayTimeDurationValue)tz;
                int minute = dtv.getPart(4);
                if (minute < 0) {
                    minute *= -1;
                }
                sb.append(this.formatTimeZone(picture, dtv.getPart(3), minute, cal.getTimeZone(), language, place));
                break;
            }
            default: {
                throw new XPathException((Expression)this, ErrorCodes.FOFD1340, "Unrecognized date/time component: " + component);
            }
        }
    }

    private String formatTimeZone(String timezonePicture, int hour, int minute, TimeZone timeZone, Optional<String> language, Optional<String> place) {
        String format;
        Locale locale = new Locale(language.orElse(DEFAULT_LANGUAGE));
        switch (timezonePicture) {
            case "0": {
                if (minute != 0) {
                    format = "%+d:%02d";
                    break;
                }
                format = "%+d";
                break;
            }
            case "0000": {
                format = "%+03d%02d";
                break;
            }
            case "0:00": {
                format = "%+d:%02d";
                break;
            }
            case "00:00t": {
                if (hour == 0 && minute == 0) {
                    format = "Z";
                    break;
                }
                format = "%+03d:%02d";
                break;
            }
            case "N": {
                TimeZone tz = place.map(TimeZone::getTimeZone).orElse(timeZone);
                return tz.getDisplayName(timeZone.useDaylightTime(), 0, locale);
            }
            case "Z": {
                return this.formatMilitaryTimeZone(hour, minute);
            }
            default: {
                format = "%+03d:%02d";
            }
        }
        return String.format(locale, format, hour, minute);
    }

    private String formatMilitaryTimeZone(int hour, int minute) {
        if (minute == 0 && hour > -12 && hour < 12) {
            int offset = hour < 0 ? 13 + hour * -1 : hour;
            return String.valueOf(MILITARY_TZ_CHARS[offset]);
        }
        return String.format("%+03d:%02d", hour, minute);
    }

    private String getDefaultFormat(char specifier) {
        switch (specifier) {
            case 'F': {
                return "Nn";
            }
            case 'P': {
                return "n";
            }
            case 'C': 
            case 'E': {
                return "N";
            }
            case 'm': 
            case 's': {
                return "01";
            }
            case 'Z': 
            case 'z': {
                return "00:00";
            }
        }
        return "1";
    }

    private void formatNumber(char specifier, String picture, String width, int num, Optional<String> language, StringBuilder sb) throws XPathException {
        int[] widths;
        NumberFormatter formatter = NumberFormatter.getInstance(language.orElse(DEFAULT_LANGUAGE));
        if ("N".equals(picture) || "n".equals(picture) || "Nn".equals(picture)) {
            String name;
            switch (specifier) {
                case 'M': {
                    name = formatter.getMonth(num);
                    break;
                }
                case 'F': {
                    name = formatter.getDay(num);
                    break;
                }
                case 'P': {
                    name = formatter.getAmPm(num);
                    break;
                }
                default: {
                    name = "";
                }
            }
            if ("N".equals(picture)) {
                name = name.toUpperCase();
            } else if ("n".equals(picture)) {
                name = name.toLowerCase();
            }
            int[] widths2 = this.getWidths(width);
            if (widths2 != null) {
                int min = widths2[0];
                int max = widths2[1];
                StringBuilder ws = new StringBuilder();
                while (name.length() < min) {
                    ws.append(" ");
                }
                if ((name = name + ws.toString()).length() > max) {
                    name = name.substring(0, max);
                }
            }
            sb.append(name);
            return;
        }
        int min = NumberFormatter.getMinDigits(picture);
        int max = NumberFormatter.getMaxDigits(picture);
        if (max == 1) {
            max = Integer.MAX_VALUE;
        }
        if ((widths = this.getWidths(width)) != null) {
            if (widths[0] > 0) {
                min = widths[0];
            }
            if (widths[1] > 0) {
                max = widths[1];
            }
        }
        try {
            sb.append(formatter.formatNumber(num, picture, min, max));
        }
        catch (XPathException e) {
            throw new XPathException((Expression)this, ErrorCodes.FOFD1350, e.getMessage());
        }
    }

    private int[] getWidths(String width) throws XPathException {
        if (width == null || width.length() == 0) {
            return null;
        }
        int min = -1;
        int max = -1;
        String minPart = width;
        String maxPart = null;
        int p = width.indexOf(45);
        if (p < 0) {
            minPart = width;
        } else {
            minPart = width.substring(0, p);
            maxPart = width.substring(p + 1);
        }
        if ("*".equals(minPart)) {
            min = 1;
        } else {
            try {
                min = Integer.parseInt(minPart);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (maxPart != null) {
            if ("*".equals(maxPart)) {
                max = Integer.MAX_VALUE;
            } else {
                try {
                    max = Integer.parseInt(maxPart);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (max != -1 && min > max) {
            throw new XPathException((Expression)this, ErrorCodes.FOFD1350, "Minimum width > maximum width in component");
        }
        return new int[]{min, max};
    }
}

