/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import org.exist.dom.QName;
import org.exist.dom.memtree.NodeImpl;
import org.exist.dom.persistent.NodeProxy;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.w3c.dom.Node;

public class FnHasChildren
extends Function {
    private static final QName QN_HAS_CHILDREN = new QName("has-children", "http://www.w3.org/2005/xpath-functions");
    public static final FunctionSignature FNS_HAS_CHILDREN_0 = new FunctionSignature(QN_HAS_CHILDREN, "Returns true if the context item has one or more child nodes", FunctionSignature.NO_ARGS, new FunctionReturnSequenceType(23, 2, "true if the context item has one of more child nodes, false otherwise"));
    public static final FunctionSignature FNS_HAS_CHILDREN_1 = new FunctionSignature(QN_HAS_CHILDREN, "Returns true if the supplied node has one or more child nodes", new SequenceType[]{new FunctionParameterSequenceType("node", -1, 3, "The node to test")}, new FunctionReturnSequenceType(23, 2, "true if $node has one of more child nodes, false otherwise"));

    public FnHasChildren(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Node w3cNode;
        NodeValue node;
        if (this.getArgumentCount() == 0) {
            if (contextItem == null) {
                throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Context item is absent");
            }
            contextSequence = contextItem.toSequence();
            if (contextSequence.isEmpty()) {
                return BooleanValue.FALSE;
            }
            Item item = contextSequence.itemAt(0);
            if (!Type.subTypeOf(item.getType(), -1)) {
                throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "Context item is not a node()");
            }
            node = (NodeValue)item;
        } else {
            Sequence arg0 = this.getArgument(0).eval(contextSequence, contextItem);
            if (this.getArgumentCount() == 1 && arg0.isEmpty()) {
                return BooleanValue.FALSE;
            }
            node = (NodeValue)arg0.itemAt(0);
        }
        if (node instanceof NodeProxy) {
            w3cNode = node.getNode();
        } else if (node instanceof NodeImpl) {
            w3cNode = (NodeImpl)node;
        } else {
            throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "Context item is not a node()");
        }
        return BooleanValue.valueOf(w3cNode.hasChildNodes());
    }
}

