/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.util.XMLChar;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class FunCodepointsToString
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(FunCodepointsToString.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("codepoints-to-string", "http://www.w3.org/2005/xpath-functions", ""), "Creates an xs:string from a sequence of code points. Returns the zero-length string if $codepoints is the empty sequence. If any of the code points in $codepoints is not a legal XML character, an error is raised", new SequenceType[]{new FunctionParameterSequenceType("codepoints", 31, 7, "The codepoints as a sequence of xs:integer values")}, new FunctionReturnSequenceType(22, 2, "The string constructed from the codepoints if valid"));

    public FunCodepointsToString(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        StringValue result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        if (args[0].isEmpty()) {
            result = StringValue.EMPTY_STRING;
        } else {
            StringBuilder buf = new StringBuilder();
            SequenceIterator i = args[0].iterate();
            while (i.hasNext()) {
                long next = ((NumericValue)i.nextItem()).getLong();
                if (next < 0L || next > Integer.MAX_VALUE || !XMLChar.isValid((int)next)) {
                    throw new XPathException((Expression)this, ErrorCodes.FOCH0001, "Codepoint " + next + " is not a valid character.");
                }
                if (next < 65536L) {
                    buf.append((char)next);
                    continue;
                }
                buf.append(XMLChar.highSurrogate((int)next));
                buf.append(XMLChar.lowSurrogate((int)next));
            }
            result = new StringValue(buf.toString());
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

