/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import com.ibm.icu.text.Collator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.memtree.ReferenceNode;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.fn.CollatingFunction;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class FunDeepEqual
extends CollatingFunction {
    protected static final Logger logger = LogManager.getLogger(FunDeepEqual.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("deep-equal", "http://www.w3.org/2005/xpath-functions"), "Returns true() iff every item in $items-1 is deep-equal to the item at the same position in $items-2, false() otherwise. If both $items-1 and $items-2 are the empty sequence, returns true(). ", new SequenceType[]{new FunctionParameterSequenceType("items-1", 11, 7, "The first item sequence"), new FunctionParameterSequenceType("items-2", 11, 7, "The second item sequence")}, new FunctionReturnSequenceType(23, 2, "true() if the sequences are deep-equal, false() otherwise")), new FunctionSignature(new QName("deep-equal", "http://www.w3.org/2005/xpath-functions"), "Returns true() iff every item in $items-1 is deep-equal to the item at the same position in $items-2, false() otherwise. If both $items-1 and $items-2 are the empty sequence, returns true(). Comparison collation is specified by $collation-uri. The third argument $collation-uri is either: 1) the full URI e.g. \"http://www.w3.org/2013/collation/UCA?lang=en;strength=secondary\", or 2) relative where you only need to specify the last part of a valid full collation-uri, e.g. \"?lang=sv-SE\", \"lang=sv-SE;strength=primary;decomposition=standard\" or \"swedish\".", new SequenceType[]{new FunctionParameterSequenceType("items-1", 11, 7, "The first item sequence"), new FunctionParameterSequenceType("items-2", 11, 7, "The second item sequence"), new FunctionParameterSequenceType("collation-uri", 22, 2, "The collation URI")}, new FunctionReturnSequenceType(23, 2, "true() if the sequences are deep-equal, false() otherwise"))};

    public FunDeepEqual(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public int getDependencies() {
        return 3;
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        Sequence[] args = this.getArguments(contextSequence, contextItem);
        Collator collator = this.getCollator(contextSequence, contextItem, 3);
        BooleanValue result = BooleanValue.valueOf(FunDeepEqual.deepEqualsSeq(args[0], args[1], collator));
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    public static boolean deepEqualsSeq(Sequence sa, Sequence sb, Collator collator) {
        int length = sa.getItemCount();
        if (length != sb.getItemCount()) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (FunDeepEqual.deepEquals(sa.itemAt(i), sb.itemAt(i), collator)) continue;
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    public static boolean deepEquals(Item a, Item b, Collator collator) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean compareElements(Node a, Node b) {
        return FunDeepEqual.compareNames(a, b) && FunDeepEqual.compareAttributes(a, b) && FunDeepEqual.compareContents(a, b);
    }

    private static boolean compareContents(Node a, Node b) {
        a = FunDeepEqual.findNextTextOrElementNode(a.getFirstChild());
        b = FunDeepEqual.findNextTextOrElementNode(b.getFirstChild());
        while (a != null && b != null) {
            int nodeTypeB;
            int nodeTypeA = FunDeepEqual.getEffectiveNodeType(a);
            if (nodeTypeA != (nodeTypeB = FunDeepEqual.getEffectiveNodeType(b))) {
                return false;
            }
            switch (nodeTypeA) {
                case 3: {
                    if (!(a.getNodeType() == 100 && b.getNodeType() == 100 ? !FunDeepEqual.safeEquals(((ReferenceNode)a).getReference().getNodeValue(), ((ReferenceNode)b).getReference().getNodeValue()) : (a.getNodeType() == 100 ? !FunDeepEqual.safeEquals(((ReferenceNode)a).getReference().getNodeValue(), b.getNodeValue()) : (b.getNodeType() == 100 ? !FunDeepEqual.safeEquals(a.getNodeValue(), ((ReferenceNode)b).getReference().getNodeValue()) : !FunDeepEqual.safeEquals(a.getNodeValue(), b.getNodeValue()))))) break;
                    return false;
                }
                case 1: {
                    if (FunDeepEqual.compareElements(a, b)) break;
                    return false;
                }
                default: {
                    throw new RuntimeException("unexpected node type " + nodeTypeA);
                }
            }
            a = FunDeepEqual.findNextTextOrElementNode(a.getNextSibling());
            b = FunDeepEqual.findNextTextOrElementNode(b.getNextSibling());
        }
        return a == b;
    }

    private static Node findNextTextOrElementNode(Node n) {
        while (n != null) {
            int nodeType = FunDeepEqual.getEffectiveNodeType(n);
            if (nodeType == 1 || nodeType == 3) {
                return n;
            }
            n = n.getNextSibling();
        }
        return null;
    }

    private static int getEffectiveNodeType(Node n) {
        short nodeType = n.getNodeType();
        if (nodeType == 100) {
            nodeType = ((ReferenceNode)n).getReference().getNode().getNodeType();
        }
        return nodeType;
    }

    private static boolean compareAttributes(Node a, Node b) {
        NamedNodeMap nnma = a.getAttributes();
        NamedNodeMap nnmb = b.getAttributes();
        if (FunDeepEqual.getAttrCount(nnma) != FunDeepEqual.getAttrCount(nnmb)) {
            return false;
        }
        for (int i = 0; i < nnma.getLength(); ++i) {
            Node tb;
            Node ta = nnma.item(i);
            String nsA = ta.getNamespaceURI();
            if (nsA != null && "http://www.w3.org/2000/xmlns/".equals(nsA)) continue;
            Node node = tb = ta.getLocalName() == null ? nnmb.getNamedItem(ta.getNodeName()) : nnmb.getNamedItemNS(ta.getNamespaceURI(), ta.getLocalName());
            if (tb != null && FunDeepEqual.safeEquals(ta.getNodeValue(), tb.getNodeValue())) continue;
            return false;
        }
        return true;
    }

    private static int getAttrCount(NamedNodeMap nnm) {
        int count = 0;
        for (int i = 0; i < nnm.getLength(); ++i) {
            Node n = nnm.item(i);
            String ns = n.getNamespaceURI();
            if (ns != null && "http://www.w3.org/2000/xmlns/".equals(ns)) continue;
            ++count;
        }
        return count;
    }

    private static boolean compareNames(Node a, Node b) {
        if (a.getLocalName() != null || b.getLocalName() != null) {
            return FunDeepEqual.safeEquals(a.getNamespaceURI(), b.getNamespaceURI()) && FunDeepEqual.safeEquals(a.getLocalName(), b.getLocalName());
        }
        return FunDeepEqual.safeEquals(a.getNodeName(), b.getNodeName());
    }

    private static boolean safeEquals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }
}

