/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import com.ibm.icu.text.Collator;
import org.exist.dom.QName;
import org.exist.util.Collations;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.fn.CollatingFunction;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunEndsWith
extends CollatingFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("ends-with", "http://www.w3.org/2005/xpath-functions"), "Returns true() if the string value of $suffix is a suffix of the string value of $source-string, false() otherwise. If either $source-string or $suffix is the empty sequence, the empty sequence is returned.", new SequenceType[]{new FunctionParameterSequenceType("source-string", 22, 3, "The source-string"), new FunctionParameterSequenceType("suffix", 22, 3, "The suffix")}, new FunctionReturnSequenceType(23, 2, "true() if $suffix is suffix of $source-string, false() otherwise")), new FunctionSignature(new QName("ends-with", "http://www.w3.org/2005/xpath-functions"), "Returns true() if the string value of $suffix is a suffix of the string value of $source-string using collation $collation-uri, false() otherwise. If either $source-string or $suffix is the empty sequence, the empty sequence is returned. The third argument $collation-uri is either: 1) the full URI e.g. \"http://www.w3.org/2013/collation/UCA?lang=en;strength=secondary\", or 2) relative where you only need to specify the last part of a valid full collation-uri, e.g. \"?lang=sv-SE\", \"lang=sv-SE;strength=primary;decomposition=standard\" or \"swedish\".", new SequenceType[]{new FunctionParameterSequenceType("source-string", 22, 3, "The source string"), new FunctionParameterSequenceType("suffix", 22, 3, "The suffix"), new FunctionParameterSequenceType("collation-uri", 22, 2, "The collation URI")}, new FunctionReturnSequenceType(23, 3, "true() if $suffix is suffix of $source-string, false() otherwise"))};

    public FunEndsWith(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public int returnsType() {
        return 23;
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Collator collator;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        Sequence s1 = this.getArgument(0).eval(contextSequence, contextItem);
        Sequence s2 = this.getArgument(1).eval(contextSequence, contextItem);
        Sequence result = s1.isEmpty() || s2.isEmpty() ? Sequence.EMPTY_SEQUENCE : (Collations.endsWith(collator = this.getCollator(contextSequence, contextItem, 3), s1.getStringValue(), s2.getStringValue()) ? BooleanValue.TRUE : BooleanValue.FALSE);
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

