/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.QNameValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunError
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(FunError.class);
    public static final FunctionSignature[] signature = new FunctionSignature[]{new FunctionSignature(new QName("error", "http://www.w3.org/2005/xpath-functions"), "Indicates that an irrecoverable error has occurred. The script will terminate immediately with an exception using the default qname, 'http://www.w3.org/2004/07/xqt-errors#err:FOER0000', and the default error message, 'An error has been raised by the query'.", null, new SequenceType(10, 1)), new FunctionSignature(new QName("error", "http://www.w3.org/2005/xpath-functions"), "Indicates that an irrecoverable error has occurred. The script will terminate immediately with an exception using $qname and the default message, 'An error has been raised by the query'.", new SequenceType[]{new FunctionParameterSequenceType("qname", 24, 2, "The qname")}, new SequenceType(10, 1)), new FunctionSignature(new QName("error", "http://www.w3.org/2005/xpath-functions"), "Indicates that an irrecoverable error has occurred. The script will terminate immediately with an exception using $qname and $message.", new SequenceType[]{new FunctionParameterSequenceType("qname", 24, 3, "The qname"), new FunctionParameterSequenceType("message", 22, 2, "The message")}, new SequenceType(10, 1)), new FunctionSignature(new QName("error", "http://www.w3.org/2005/xpath-functions"), "Indicates that an irrecoverable error has occurred. The script will terminate immediately with an exception using $qname and $message with $error-object appended.", new SequenceType[]{new FunctionParameterSequenceType("qname", 24, 3, "The qname"), new FunctionParameterSequenceType("message", 22, 2, "The message"), new FunctionParameterSequenceType("error-object", 11, 7, "The error object")}, new SequenceType(10, 1))};
    public static final ErrorCodes.ErrorCode DEFAULT_ERROR = ErrorCodes.FOER0000;
    public static final String DEFAULT_DESCRIPTION = "An error has been raised by the query";

    public FunError(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public int returnsType() {
        return 10;
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        ErrorCodes.ErrorCode errorCode = DEFAULT_ERROR;
        String errorDesc = DEFAULT_DESCRIPTION;
        Sequence errorVal = Sequence.EMPTY_SEQUENCE;
        if (args.length > 0) {
            if (args.length > 1) {
                errorDesc = args[1].getStringValue();
            }
            if (!args[0].isEmpty()) {
                QName errorQName = ((QNameValue)args[0].itemAt(0)).getQName();
                String prefix = errorQName.getPrefix();
                if (prefix == null) {
                    String ns = errorQName.getNamespaceURI();
                    prefix = this.getContext().getPrefixForURI(ns);
                    errorQName = new QName(errorQName.getLocalPart(), errorQName.getNamespaceURI(), prefix);
                }
                errorCode = new ErrorCodes.ErrorCode(errorQName, errorDesc);
            }
            if (args.length == 3) {
                errorVal = args[2];
            }
        }
        logger.error(errorDesc + ": " + errorCode.toString());
        throw new XPathException(this, errorCode, errorDesc, errorVal);
    }
}

