/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunFloor
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("floor", "http://www.w3.org/2005/xpath-functions"), "Returns the largets number not greater than the value of $number. If $number is the empty sequence, returns the empty sequence.", new SequenceType[]{new FunctionParameterSequenceType("number", 30, 7, "The number")}, new FunctionReturnSequenceType(30, 2, "the largets number without fraction part not greater than the value of $number"));

    public FunFloor(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public int returnsType() {
        return 30;
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        Sequence seq;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if ((seq = this.getArgument(0).eval(contextSequence, contextItem)).isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            Item item = seq.itemAt(0);
            NumericValue value = item instanceof NumericValue ? (NumericValue)item : (NumericValue)item.convertTo(30);
            result = value.floor();
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

