/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;

public class FunGenerateId
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("generate-id", "http://www.w3.org/2005/xpath-functions"), "This function returns a string that uniquely identifies a given node. Without an argument, the node to identify is taken from the current context item.", null, new FunctionReturnSequenceType(22, 2, "Unique identifier for the node")), new FunctionSignature(new QName("generate-id", "http://www.w3.org/2005/xpath-functions"), "This function returns a string that uniquely identifies a given node.", new SequenceType[]{new FunctionParameterSequenceType("node", -1, 3, "The node for which an identifier will be generated. If it is the empty sequence, the result will be the empty string")}, new FunctionReturnSequenceType(22, 2, "Unique identifier for the node"))};

    public FunGenerateId(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        NodeValue node = null;
        if (this.getArgumentCount() == 0) {
            if (contextSequence.isEmpty()) {
                throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "No context item available in call to generate-id");
            }
            Item contextItem = contextSequence.itemAt(0);
            if (Type.subTypeOf(contextItem.getType(), -1)) {
                throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "Context item is not a node in call to generate-id");
            }
            node = (NodeValue)contextItem;
        } else {
            if (args[0].isEmpty()) {
                return StringValue.EMPTY_STRING;
            }
            node = (NodeValue)args[0].itemAt(0);
        }
        String id = node.getNodeId().toString();
        return new StringValue("N" + id);
    }
}

