/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import org.exist.dom.QName;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.RangeSequence;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.array.ArrayType;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReference;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public class FunHigherOrderFun
extends BasicFunction {
    public static final FunctionSignature FN_FOR_EACH = new FunctionSignature(new QName("for-each", "http://www.w3.org/2005/xpath-functions"), "Applies the function item $function to every item from the sequence $sequence in turn, returning the concatenation of the resulting sequences in order.", new SequenceType[]{new FunctionParameterSequenceType("sequence", 11, 7, "the sequence on which to apply the function"), new FunctionParameterSequenceType("function", 101, 2, "the function to call")}, new FunctionReturnSequenceType(11, 7, "result of applying the function to each item of the sequence"));
    public static final FunctionSignature FN_FOR_EACH_PAIR = new FunctionSignature(new QName("for-each-pair", "http://www.w3.org/2005/xpath-functions"), "Applies the function item $f to successive pairs of items taken one from $seq1 and one from $seq2, returning the concatenation of the resulting sequences in order.", new SequenceType[]{new FunctionParameterSequenceType("seq1", 11, 7, "first sequence to take items from"), new FunctionParameterSequenceType("seq2", 11, 7, "second sequence to take items from"), new FunctionParameterSequenceType("function", 101, 2, "the function to call")}, new FunctionReturnSequenceType(11, 7, "concatenation of resulting sequences"));
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("map", "http://www.w3.org/2005/xpath-functions"), "Applies the function item $function to every item from the sequence $sequence in turn, returning the concatenation of the resulting sequences in order.", new SequenceType[]{new FunctionParameterSequenceType("function", 101, 2, "the function to call"), new FunctionParameterSequenceType("sequence", 11, 7, "the sequence on which to apply the function")}, (SequenceType)new FunctionReturnSequenceType(11, 7, "result of applying the function to each item of the sequence"), FN_FOR_EACH), FN_FOR_EACH, new FunctionSignature(new QName("filter", "http://www.w3.org/2005/xpath-functions"), "Returns those items from the sequence $sequence for which the supplied function $function returns true.", new SequenceType[]{new FunctionParameterSequenceType("sequence", 11, 7, "the sequence to filter"), new FunctionParameterSequenceType("function", 101, 2, "the function to call")}, new FunctionReturnSequenceType(11, 7, "result of filtering the sequence")), new FunctionSignature(new QName("fold-left", "http://www.w3.org/2005/xpath-functions"), "Processes the supplied sequence from left to right, applying the supplied function repeatedly to each item in turn, together with an accumulated result value.", new SequenceType[]{new FunctionParameterSequenceType("sequence", 11, 7, "the sequence to filter"), new FunctionParameterSequenceType("zero", 11, 7, "initial value to start with"), new FunctionParameterSequenceType("function", 101, 2, "the function to call")}, new FunctionReturnSequenceType(11, 7, "result of the fold-left operation")), new FunctionSignature(new QName("fold-right", "http://www.w3.org/2005/xpath-functions"), "Processes the supplied sequence from right to left, applying the supplied function repeatedly to each item in turn, together with an accumulated result value.", new SequenceType[]{new FunctionParameterSequenceType("sequence", 11, 7, "the sequence to filter"), new FunctionParameterSequenceType("zero", 11, 7, "initial value to start with"), new FunctionParameterSequenceType("function", 101, 2, "the function to call")}, new FunctionReturnSequenceType(11, 7, "result of the fold-right operation")), new FunctionSignature(new QName("map-pairs", "http://www.w3.org/2005/xpath-functions"), "Applies the function item $f to successive pairs of items taken one from $seq1 and one from $seq2, returning the concatenation of the resulting sequences in order.", new SequenceType[]{new FunctionParameterSequenceType("function", 101, 2, "the function to call"), new FunctionParameterSequenceType("seq1", 11, 7, "first sequence to take items from"), new FunctionParameterSequenceType("seq2", 11, 7, "second sequence to take items from")}, (SequenceType)new FunctionReturnSequenceType(11, 7, "result of the map-pairs operation"), FN_FOR_EACH_PAIR), FN_FOR_EACH_PAIR, new FunctionSignature(new QName("apply", "http://www.w3.org/2005/xpath-functions"), "Processes the supplied sequence from right to left, applying the supplied function repeatedly to each item in turn, together with an accumulated result value.", new SequenceType[]{new FunctionParameterSequenceType("function", 101, 2, "the function to call"), new FunctionParameterSequenceType("array", 103, 2, "an array containing the arguments to pass to the function")}, new FunctionReturnSequenceType(11, 7, "return value of the function call"))};
    private AnalyzeContextInfo cachedContextInfo;

    public FunHigherOrderFun(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    protected void checkArguments() throws XPathException {
        if (!this.isCalledAs("filter")) {
            super.checkArguments();
        }
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        this.cachedContextInfo = new AnalyzeContextInfo(contextInfo);
        super.analyze(this.cachedContextInfo);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence result = new ValueSequence();
        if (this.isCalledAs("map")) {
            FunctionReference ref = (FunctionReference)args[0].itemAt(0);
            ref.analyze(this.cachedContextInfo);
            SequenceIterator i = args[1].iterate();
            while (i.hasNext()) {
                Item item = i.nextItem();
                Sequence r = ref.evalFunction(contextSequence, null, new Sequence[]{item.toSequence()});
                result.addAll(r);
            }
        } else if (this.isCalledAs("for-each")) {
            FunctionReference ref = (FunctionReference)args[1].itemAt(0);
            ref.analyze(this.cachedContextInfo);
            SequenceIterator i = args[0].iterate();
            while (i.hasNext()) {
                Item item = i.nextItem();
                Sequence r = ref.evalFunction(contextSequence, null, new Sequence[]{item.toSequence()});
                result.addAll(r);
            }
        } else if (this.isCalledAs("filter")) {
            Sequence seq;
            FunctionReference ref;
            if (Type.subTypeOf(args[1].getItemType(), 101)) {
                ref = (FunctionReference)args[1].itemAt(0);
                seq = args[0];
            } else {
                ref = (FunctionReference)args[0].itemAt(0);
                seq = args[1];
            }
            ref.analyze(this.cachedContextInfo);
            SequenceIterator i = seq.iterate();
            while (i.hasNext()) {
                Item item = i.nextItem();
                Sequence r = ref.evalFunction(contextSequence, null, new Sequence[]{item.toSequence()});
                if (!r.effectiveBooleanValue()) continue;
                result.add(item);
            }
        } else if (this.isCalledAs("fold-left")) {
            FunctionReference ref = (FunctionReference)args[2].itemAt(0);
            ref.analyze(this.cachedContextInfo);
            Sequence seq = args[0];
            Sequence zero = args[1];
            result = this.foldLeft(ref, zero, seq.iterate(), contextSequence);
        } else if (this.isCalledAs("fold-right")) {
            FunctionReference ref = (FunctionReference)args[2].itemAt(0);
            ref.analyze(this.cachedContextInfo);
            Sequence zero = args[1];
            Sequence seq = args[0];
            result = seq instanceof ValueSequence ? this.foldRightNonRecursive(ref, zero, ((ValueSequence)seq).iterateInReverse(), contextSequence) : (seq instanceof RangeSequence ? this.foldRightNonRecursive(ref, zero, ((RangeSequence)seq).iterateInReverse(), contextSequence) : this.foldRight(ref, zero, seq, contextSequence));
        } else if (this.isCalledAs("map-pairs")) {
            FunctionReference ref = (FunctionReference)args[0];
            ref.analyze(this.cachedContextInfo);
            SequenceIterator i1 = args[1].iterate();
            SequenceIterator i2 = args[2].iterate();
            while (i1.hasNext() && i2.hasNext()) {
                Sequence r = ref.evalFunction(contextSequence, null, new Sequence[]{i1.nextItem().toSequence(), i2.nextItem().toSequence()});
                result.addAll(r);
            }
        } else if (this.isCalledAs("for-each-pair")) {
            FunctionReference ref = (FunctionReference)args[2].itemAt(0);
            ref.analyze(this.cachedContextInfo);
            SequenceIterator i1 = args[0].iterate();
            SequenceIterator i2 = args[1].iterate();
            while (i1.hasNext() && i2.hasNext()) {
                Sequence r = ref.evalFunction(contextSequence, null, new Sequence[]{i1.nextItem().toSequence(), i2.nextItem().toSequence()});
                result.addAll(r);
            }
        } else if (this.isCalledAs("apply")) {
            FunctionReference ref = (FunctionReference)args[0].itemAt(0);
            ref.analyze(this.cachedContextInfo);
            ArrayType array = (ArrayType)args[1].itemAt(0);
            if (!ref.getSignature().isOverloaded() && ref.getSignature().getArgumentCount() != array.getSize()) {
                throw new XPathException((Expression)this, ErrorCodes.FOAP0001, "Number of arguments supplied to fn:apply does not match function signature. Expected: " + ref.getSignature().getArgumentCount() + ", got: " + array.getSize());
            }
            Sequence[] fargs = array.toArray();
            return ref.evalFunction(null, null, fargs);
        }
        return result;
    }

    private Sequence foldLeft(FunctionReference ref, Sequence accum, SequenceIterator seq, Sequence contextSequence) throws XPathException {
        Sequence[] refArgs = new Sequence[2];
        while (seq.hasNext()) {
            refArgs[0] = accum;
            refArgs[1] = seq.nextItem().toSequence();
            accum = ref.evalFunction(contextSequence, null, refArgs);
        }
        return accum;
    }

    private Sequence foldRightNonRecursive(FunctionReference ref, Sequence accum, SequenceIterator seq, Sequence contextSequence) throws XPathException {
        Sequence[] refArgs = new Sequence[2];
        while (seq.hasNext()) {
            refArgs[0] = seq.nextItem().toSequence();
            refArgs[1] = accum;
            accum = ref.evalFunction(contextSequence, null, refArgs);
        }
        return accum;
    }

    private Sequence foldRight(FunctionReference ref, Sequence zero, Sequence seq, Sequence contextSequence) throws XPathException {
        if (seq.isEmpty()) {
            return zero;
        }
        Sequence head = seq.itemAt(0).toSequence();
        Sequence tailResult = this.foldRight(ref, zero, seq.tail(), contextSequence);
        return ref.evalFunction(contextSequence, null, new Sequence[]{head, tailResult});
    }
}

