/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.memtree.DocumentImpl;
import org.exist.dom.memtree.NodeImpl;
import org.exist.dom.persistent.DefaultDocumentSet;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.ExtArrayNodeSet;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeSet;
import org.exist.util.XMLChar;
import org.exist.xquery.Constants;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public class FunId
extends Function {
    protected static final Logger logger = LogManager.getLogger(FunId.class);
    public static final FunctionSignature[] signature = new FunctionSignature[]{new FunctionSignature(new QName("id", "http://www.w3.org/2005/xpath-functions"), "Returns the sequence of element nodes that have an ID value matching the value of one or more of the IDREF values supplied in $idrefs. If none is matching or $idrefs is the empty sequence, returns the empty sequence.", new SequenceType[]{new FunctionParameterSequenceType("idrefs", 22, 7, "The IDREF sequence")}, new FunctionReturnSequenceType(1, 7, "the elements with IDs  matching IDREFs from $idref-sequence")), new FunctionSignature(new QName("id", "http://www.w3.org/2005/xpath-functions"), "Returns the sequence of element nodes that have an ID value matching the value of one or more of the IDREF values supplied in $idrefs and is in the same document as $node-in-document. If none is matching or $idrefs is the empty sequence, returns the empty sequence.", new SequenceType[]{new FunctionParameterSequenceType("idrefs", 22, 7, "The IDREF sequence"), new FunctionParameterSequenceType("node-in-document", -1, 2, "The node in document")}, new FunctionReturnSequenceType(1, 7, "the elements with IDs matching IDREFs from $idrefs in the same document as $node-in-document"))};

    public FunId(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (this.getArgumentCount() < 1) {
            logger.error("function id requires one argument");
            throw new XPathException((Expression)this, ErrorCodes.XPST0017, "function id requires one argument");
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        boolean processInMem = false;
        Expression arg = this.getArgument(0);
        Sequence idval = arg.eval(contextSequence);
        if (idval.isEmpty() || this.getArgumentCount() == 1 && contextSequence != null && contextSequence.isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            DocumentSet docs = null;
            if (this.getArgumentCount() == 2) {
                Sequence nodes = this.getArgument(1).eval(contextSequence);
                if (nodes.isEmpty()) {
                    logger.error(ErrorCodes.XPDY0002 + " No node or context item for fn:id");
                    throw new XPathException(this, ErrorCodes.XPDY0002, "XPDY0002: no node or context item for fn:id", nodes);
                }
                if (!Type.subTypeOf(nodes.itemAt(0).getType(), -1)) {
                    logger.error(ErrorCodes.XPTY0004 + " fn:id() argument is not a node");
                    throw new XPathException(this, ErrorCodes.XPTY0004, "XPTY0004: fn:id() argument is not a node", nodes);
                }
                NodeValue node = (NodeValue)nodes.itemAt(0);
                if (node.getImplementationType() == 0) {
                    processInMem = true;
                } else {
                    DefaultDocumentSet ndocs = new DefaultDocumentSet();
                    ndocs.add(((NodeProxy)node).getOwnerDocument());
                    docs = ndocs;
                }
                contextSequence = node;
            } else {
                if (contextSequence == null) {
                    logger.error(ErrorCodes.XPDY0002 + " No context item specified");
                    throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "No context item specified");
                }
                if (!Type.subTypeOf(contextSequence.getItemType(), -1)) {
                    logger.error(ErrorCodes.XPTY0004 + " Context item is not a node");
                    throw new XPathException(this, ErrorCodes.XPTY0004, "Context item is not a node", contextSequence);
                }
                if (contextSequence.isPersistentSet()) {
                    docs = contextSequence.toNodeSet().getDocumentSet();
                } else {
                    processInMem = true;
                }
            }
            result = processInMem ? new ValueSequence() : new ExtArrayNodeSet();
            SequenceIterator i = idval.iterate();
            while (i.hasNext()) {
                String nextId = i.nextItem().getStringValue();
                if (nextId.length() == 0) continue;
                if (nextId.indexOf(" ") != -1) {
                    StringTokenizer tok = new StringTokenizer(nextId, " ");
                    while (tok.hasMoreTokens()) {
                        nextId = tok.nextToken();
                        if (!XMLChar.isValidNCName(nextId)) continue;
                        if (processInMem) {
                            this.getId(result, contextSequence, nextId);
                            continue;
                        }
                        this.getId((NodeSet)result, docs, nextId);
                    }
                    continue;
                }
                if (!XMLChar.isValidNCName(nextId)) continue;
                if (processInMem) {
                    this.getId(result, contextSequence, nextId);
                    continue;
                }
                this.getId((NodeSet)result, docs, nextId);
            }
        }
        result.removeDuplicates();
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    private void getId(NodeSet result, DocumentSet docs, String id) throws XPathException {
        NodeSet attribs = this.context.getBroker().getValueIndex().find(this.context.getWatchDog(), Constants.Comparison.EQ, docs, null, -1, null, new StringValue(id, 66));
        for (NodeProxy n : attribs) {
            NodeProxy p = new NodeProxy(n.getOwnerDocument(), n.getNodeId().getParentId(), 1);
            result.add(p);
        }
    }

    private void getId(Sequence result, Sequence seq, String id) throws XPathException {
        TreeSet<DocumentImpl> visitedDocs = new TreeSet<DocumentImpl>();
        SequenceIterator i = seq.iterate();
        while (i.hasNext()) {
            NodeImpl v = (NodeImpl)i.nextItem();
            DocumentImpl doc = v.getOwnerDocument();
            if (doc == null || visitedDocs.contains(doc)) continue;
            NodeImpl elem = doc.selectById(id);
            if (elem != null) {
                result.add(elem);
            }
            visitedDocs.add(doc);
        }
    }

    @Override
    public int getDependencies() {
        return this.getArgument(0).getDependencies();
    }
}

