/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.memtree.DocumentImpl;
import org.exist.dom.memtree.NodeImpl;
import org.exist.dom.persistent.DefaultDocumentSet;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.ExtArrayNodeSet;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeSet;
import org.exist.util.XMLChar;
import org.exist.xquery.Constants;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public class FunIdRef
extends Function {
    protected static final Logger logger = LogManager.getLogger(FunIdRef.class);
    public static final FunctionSignature[] signature = new FunctionSignature[]{new FunctionSignature(new QName("idref", "http://www.w3.org/2005/xpath-functions"), "Returns the sequence of element or attributes nodes with an IDREF value matching the value of one or more of the ID values supplied in $ids. If none is matching or $ids is the empty sequence, returns the empty sequence.", new SequenceType[]{new FunctionParameterSequenceType("ids", 22, 7, "The ID sequence")}, new FunctionReturnSequenceType(-1, 7, "the elements with matching IDREF values from IDs in $ids")), new FunctionSignature(new QName("idref", "http://www.w3.org/2005/xpath-functions"), "Returns the sequence of element or attributes nodes with an IDREF value matching the value of one or more of the ID values supplied in $ids. If none is matching or $ids is the empty sequence, returns the empty sequence.", new SequenceType[]{new FunctionParameterSequenceType("ids", 22, 7, "The ID sequence"), new FunctionParameterSequenceType("node-in-document", -1, 2, "The node in document")}, new FunctionReturnSequenceType(-1, 7, "the elements with matching IDREF values from IDs in $ids in the same document as $node-in-document"))};

    public FunIdRef(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (this.getArgumentCount() < 1) {
            throw new XPathException((Expression)this, ErrorCodes.XPST0017, "function id requires one argument");
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        boolean processInMem = false;
        Expression arg = this.getArgument(0);
        Sequence idrefval = arg.eval(contextSequence);
        if (idrefval.isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            DocumentSet docs = null;
            if (this.getArgumentCount() == 2) {
                Sequence nodes = this.getArgument(1).eval(contextSequence);
                if (nodes.isEmpty()) {
                    throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "no node or context item for fn:idref");
                }
                if (!Type.subTypeOf(nodes.itemAt(0).getType(), -1)) {
                    throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "fn:idref() argument is not a node");
                }
                NodeValue node = (NodeValue)nodes.itemAt(0);
                if (node.getImplementationType() == 0) {
                    processInMem = true;
                } else {
                    DefaultDocumentSet ndocs = new DefaultDocumentSet();
                    ndocs.add(((NodeProxy)node).getOwnerDocument());
                    docs = ndocs;
                }
                contextSequence = node;
            } else {
                if (contextSequence == null) {
                    throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "no context item specified");
                }
                if (!Type.subTypeOf(contextSequence.getItemType(), -1)) {
                    throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "context item is not a node");
                }
                if (contextSequence.isPersistentSet()) {
                    docs = contextSequence.toNodeSet().getDocumentSet();
                } else {
                    processInMem = true;
                }
            }
            result = processInMem ? new ValueSequence() : new ExtArrayNodeSet();
            SequenceIterator i = idrefval.iterate();
            while (i.hasNext()) {
                String nextId = i.nextItem().getStringValue();
                if (nextId.length() == 0 || !XMLChar.isValidNCName(nextId)) continue;
                if (processInMem) {
                    this.getIdRef(result, contextSequence, nextId);
                    continue;
                }
                this.getIdRef((NodeSet)result, docs, nextId);
            }
        }
        result.removeDuplicates();
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    private void getIdRef(NodeSet result, DocumentSet docs, String id) throws XPathException {
        NodeSet attribs = this.context.getBroker().getValueIndex().find(this.context.getWatchDog(), Constants.Comparison.EQ, docs, null, -1, null, new StringValue(id, 67));
        for (NodeProxy n : attribs) {
            n.setNodeType((short)2);
            result.add(n);
        }
    }

    private void getIdRef(Sequence result, Sequence seq, String id) throws XPathException {
        TreeSet<DocumentImpl> visitedDocs = new TreeSet<DocumentImpl>();
        SequenceIterator i = seq.iterate();
        while (i.hasNext()) {
            NodeImpl v = (NodeImpl)i.nextItem();
            DocumentImpl doc = v.getOwnerDocument();
            if (visitedDocs.contains(doc)) continue;
            NodeImpl node = doc.selectByIdref(id);
            if (node != null) {
                result.add(node);
            }
            visitedDocs.add(doc);
        }
    }
}

