/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import org.exist.dom.QName;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.ElementImpl;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FunInScopePrefixes
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("in-scope-prefixes", "http://www.w3.org/2005/xpath-functions"), "Returns the prefixes of the in-scope namespaces for $element. For namespaces that have a prefix, it returns the prefix as an xs:NCName. For the default namespace, which has no prefix, it returns the zero-length string.", new SequenceType[]{new FunctionParameterSequenceType("element", 1, 2, "The element")}, new FunctionReturnSequenceType(22, 7, "the prefixes"));

    public FunInScopePrefixes(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        Map<String, String> prefixes = FunInScopePrefixes.collectPrefixes(this.context, (NodeValue)args[0].itemAt(0));
        ValueSequence result = new ValueSequence();
        for (String prefix : prefixes.keySet()) {
            if (this.context.getURIForPrefix(prefix) == null && ("exist".equals(prefix) || "xs".equals(prefix) || "xsi".equals(prefix) || "wdt".equals(prefix) || "fn".equals(prefix) || "local".equals(prefix))) continue;
            result.add(new StringValue(prefix));
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    public static Map<String, String> collectPrefixes(XQueryContext context, NodeValue nodeValue) {
        Stack<Element> stack;
        Node node;
        LinkedHashMap<String, String> prefixes = new LinkedHashMap<String, String>();
        prefixes.put("xml", "http://www.w3.org/XML/1998/namespace");
        Map<String, String> inScopePrefixes = context.getInScopePrefixes();
        if (inScopePrefixes != null) {
            prefixes.putAll(inScopePrefixes);
        }
        if (nodeValue.getImplementationType() == 1) {
            node = nodeValue.getNode();
            if (context.preserveNamespaces()) {
                if (context.inheritNamespaces()) {
                    stack = new Stack<Element>();
                    do {
                        stack.add((Element)node);
                    } while ((node = node.getParentNode()) != null && node.getNodeType() == 1);
                    while (!stack.isEmpty()) {
                        FunInScopePrefixes.collectNamespacePrefixes((Element)stack.pop(), prefixes);
                    }
                } else if (node.getNodeType() == 1) {
                    FunInScopePrefixes.collectNamespacePrefixes((Element)node, prefixes);
                }
            } else if (context.inheritNamespaces()) {
                stack = new Stack();
                do {
                    if (node.getParentNode() != null && !(node.getParentNode() instanceof DocumentImpl)) continue;
                    stack.add((Element)node);
                } while ((node = node.getParentNode()) != null && node.getNodeType() == 1);
                while (!stack.isEmpty()) {
                    FunInScopePrefixes.collectNamespacePrefixes((Element)stack.pop(), prefixes);
                }
            }
        } else {
            node = nodeValue.getNode();
            if (context.preserveNamespaces()) {
                if (context.inheritNamespaces()) {
                    stack = new Stack();
                    do {
                        if (node.getNodeType() != 1) continue;
                        stack.add((Element)node);
                    } while ((node = node.getParentNode()) != null && node.getNodeType() == 1);
                    while (!stack.isEmpty()) {
                        FunInScopePrefixes.collectNamespacePrefixes((Element)stack.pop(), prefixes);
                    }
                } else if (node.getNodeType() == 1) {
                    FunInScopePrefixes.collectNamespacePrefixes((Element)node, prefixes);
                }
            } else if (context.inheritNamespaces()) {
                stack = new Stack();
                do {
                    if (node.getParentNode() != null && !(node.getParentNode() instanceof org.exist.dom.memtree.DocumentImpl)) continue;
                    stack.add((Element)node);
                } while ((node = node.getParentNode()) != null && node.getNodeType() == 1);
                while (!stack.isEmpty()) {
                    FunInScopePrefixes.collectNamespacePrefixes((Element)stack.pop(), prefixes);
                }
            }
        }
        String key = null;
        String value = null;
        for (Map.Entry entry : prefixes.entrySet()) {
            key = (String)entry.getKey();
            value = (String)entry.getValue();
            if (key != null && !key.isEmpty() || value != null && !value.isEmpty()) continue;
            prefixes.remove(key);
        }
        return prefixes;
    }

    public static void collectNamespacePrefixes(Element element, Map<String, String> prefixes) {
        String prefix;
        String namespaceURI = element.getNamespaceURI();
        if (namespaceURI != null && !namespaceURI.isEmpty()) {
            prefix = element.getPrefix();
            prefixes.put(prefix == null ? "" : prefix, namespaceURI);
        }
        if (element instanceof org.exist.dom.memtree.ElementImpl) {
            ((org.exist.dom.memtree.ElementImpl)element).getNamespaceMap(prefixes);
        } else {
            ElementImpl elementImpl = (ElementImpl)element;
            if (elementImpl.declaresNamespacePrefixes()) {
                Iterator<String> i = elementImpl.getPrefixes();
                while (i.hasNext()) {
                    String prefix2 = i.next();
                    prefixes.put(prefix2, elementImpl.getNamespaceForPrefix(prefix2));
                }
            }
        }
        if (namespaceURI != null && namespaceURI.isEmpty()) {
            prefix = element.getPrefix();
            prefixes.remove(prefix == null ? "" : prefix);
        }
    }
}

