/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import com.ibm.icu.text.Collator;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Constants;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.ValueComparison;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.ValueSequence;

public class FunIndexOf
extends BasicFunction {
    protected static final FunctionReturnSequenceType RETURN_TYPE = new FunctionReturnSequenceType(31, 3, "the sequence of positive integers giving the positions within the sequence");
    protected static final FunctionParameterSequenceType COLLATION_PARAM = new FunctionParameterSequenceType("collation-uri", 22, 2, "The collation URI");
    protected static final FunctionParameterSequenceType SEARCH_PARAM = new FunctionParameterSequenceType("search", 20, 2, "The search component");
    protected static final FunctionParameterSequenceType SEQ_PARAM = new FunctionParameterSequenceType("source", 20, 7, "The source sequence");
    protected static final String FUNCTION_DESCRIPTION = "Returns a sequence of positive integers giving the positions within the sequence of atomic values $source that are equal to $search.\n\nThe collation used by the invocation of this function is determined according to the rules in 7.3.1 Collations. The collation is used when string comparison is required.\n\nThe items in the sequence $source are compared with $search under the rules for the 'eq' operator. Values of type xs:untypedAtomic are compared as if they were of type xs:string. Values that cannot be compared, i.e. the 'eq' operator is not defined for their types, are considered to be distinct. If an item compares equal, then the position of that item in the sequence $source is included in the result.\n\nIf the value of $source is the empty sequence, or if no item in $source matches $search, then the empty sequence is returned.\n\nThe first item in a sequence is at position 1, not position 0.\n\nThe result sequence is in ascending numeric order.";
    public static final FunctionSignature[] fnIndexOf = new FunctionSignature[]{new FunctionSignature(new QName("index-of", "http://www.w3.org/2005/xpath-functions"), "Returns a sequence of positive integers giving the positions within the sequence of atomic values $source that are equal to $search.\n\nThe collation used by the invocation of this function is determined according to the rules in 7.3.1 Collations. The collation is used when string comparison is required.\n\nThe items in the sequence $source are compared with $search under the rules for the 'eq' operator. Values of type xs:untypedAtomic are compared as if they were of type xs:string. Values that cannot be compared, i.e. the 'eq' operator is not defined for their types, are considered to be distinct. If an item compares equal, then the position of that item in the sequence $source is included in the result.\n\nIf the value of $source is the empty sequence, or if no item in $source matches $search, then the empty sequence is returned.\n\nThe first item in a sequence is at position 1, not position 0.\n\nThe result sequence is in ascending numeric order.", new SequenceType[]{SEQ_PARAM, SEARCH_PARAM}, RETURN_TYPE), new FunctionSignature(new QName("index-of", "http://www.w3.org/2005/xpath-functions"), "Returns a sequence of positive integers giving the positions within the sequence of atomic values $source that are equal to $search.\n\nThe collation used by the invocation of this function is determined according to the rules in 7.3.1 Collations. The collation is used when string comparison is required.\n\nThe items in the sequence $source are compared with $search under the rules for the 'eq' operator. Values of type xs:untypedAtomic are compared as if they were of type xs:string. Values that cannot be compared, i.e. the 'eq' operator is not defined for their types, are considered to be distinct. If an item compares equal, then the position of that item in the sequence $source is included in the result.\n\nIf the value of $source is the empty sequence, or if no item in $source matches $search, then the empty sequence is returned.\n\nThe first item in a sequence is at position 1, not position 0.\n\nThe result sequence is in ascending numeric order. The third argument $collation-uri is either: 1) the full URI e.g. \"http://www.w3.org/2013/collation/UCA?lang=en;strength=secondary\", or 2) relative where you only need to specify the last part of a valid full collation-uri, e.g. \"?lang=sv-SE\", \"lang=sv-SE;strength=primary;decomposition=standard\" or \"swedish\".", new SequenceType[]{SEQ_PARAM, SEARCH_PARAM, COLLATION_PARAM}, RETURN_TYPE)};

    public FunIndexOf(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Collator collator;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        AtomicValue srch = args[1].itemAt(0).atomize();
        if (this.getSignature().getArgumentCount() == 3) {
            String collation = args[2].getStringValue();
            collator = this.context.getCollator(collation);
        } else {
            collator = this.context.getDefaultCollator();
        }
        ValueSequence result = new ValueSequence();
        int j = 1;
        SequenceIterator i = args[0].iterate();
        while (i.hasNext()) {
            AtomicValue next = i.nextItem().atomize();
            try {
                if (ValueComparison.compareAtomic(collator, next, srch, Constants.StringTruncationOperator.NONE, Constants.Comparison.EQ)) {
                    result.add(new IntegerValue(j));
                }
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
            ++j;
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

