/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.w3c.dom.Node;

public class FunLocalName
extends Function {
    private static final String FUNCTION_DESCRIPTION = "Returns the local part of the name of $arg as an xs:string that will either be the zero-length string or will have the lexical form of an xs:NCName.\n\nIf the argument is omitted, it defaults to the context item (.). The behavior of the function if the argument is omitted is exactly the same as if the context item had been passed as the argument.\n\nThe following errors may be raised: if the context item is undefined [err:XPDY0002]XP; if the context item is not a node [err:XPTY0004]XP.\n\nIf the argument is supplied and is the empty sequence, the function returns the zero-length string.\n\nIf the target node has no name (that is, if it is a document node, a comment, or a text node), the function returns the zero-length string.\n\nOtherwise, the value returned will be the local part of the expanded-QName of the target node (as determined by the dm:node-name accessor in Section 5.11 node-name AccessorDM. This will be an xs:string whose lexical form is an xs:NCName.";
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("local-name", "http://www.w3.org/2005/xpath-functions"), "Returns the local part of the name of $arg as an xs:string that will either be the zero-length string or will have the lexical form of an xs:NCName.\n\nIf the argument is omitted, it defaults to the context item (.). The behavior of the function if the argument is omitted is exactly the same as if the context item had been passed as the argument.\n\nThe following errors may be raised: if the context item is undefined [err:XPDY0002]XP; if the context item is not a node [err:XPTY0004]XP.\n\nIf the argument is supplied and is the empty sequence, the function returns the zero-length string.\n\nIf the target node has no name (that is, if it is a document node, a comment, or a text node), the function returns the zero-length string.\n\nOtherwise, the value returned will be the local part of the expanded-QName of the target node (as determined by the dm:node-name accessor in Section 5.11 node-name AccessorDM. This will be an xs:string whose lexical form is an xs:NCName.", null, new FunctionReturnSequenceType(22, 2, "the local name")), new FunctionSignature(new QName("local-name", "http://www.w3.org/2005/xpath-functions"), "Returns the local part of the name of $arg as an xs:string that will either be the zero-length string or will have the lexical form of an xs:NCName.\n\nIf the argument is omitted, it defaults to the context item (.). The behavior of the function if the argument is omitted is exactly the same as if the context item had been passed as the argument.\n\nThe following errors may be raised: if the context item is undefined [err:XPDY0002]XP; if the context item is not a node [err:XPTY0004]XP.\n\nIf the argument is supplied and is the empty sequence, the function returns the zero-length string.\n\nIf the target node has no name (that is, if it is a document node, a comment, or a text node), the function returns the zero-length string.\n\nOtherwise, the value returned will be the local part of the expanded-QName of the target node (as determined by the dm:node-name accessor in Section 5.11 node-name AccessorDM. This will be an xs:string whose lexical form is an xs:NCName.", new SequenceType[]{new FunctionParameterSequenceType("arg", -1, 3, "The node to retrieve the local name from")}, new FunctionReturnSequenceType(22, 2, "the local name"))};

    public FunLocalName(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        StringValue result;
        Item item;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if (this.getArgumentCount() > 0) {
            Sequence seq = this.getArgument(0).eval(contextSequence);
            item = !seq.isEmpty() ? seq.itemAt(0) : null;
        } else {
            if (contextSequence == null) {
                throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Undefined context item");
            }
            item = contextSequence.itemAt(0);
        }
        if (item == null) {
            result = StringValue.EMPTY_STRING;
        } else {
            if (!Type.subTypeOf(item.getType(), -1)) {
                throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "item is not a node; got '" + Type.getTypeName(item.getType()) + "'");
            }
            Node n = ((NodeValue)item).getNode();
            String localName = n.getLocalName();
            result = localName != null ? new StringValue(localName) : StringValue.EMPTY_STRING;
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

