/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import com.ibm.icu.text.Collator;
import org.exist.dom.QName;
import org.exist.util.Collations;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.fn.CollatingFunction;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.DurationValue;
import org.exist.xquery.value.FloatValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.QNameValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;

public class FunMin
extends CollatingFunction {
    protected static final String FUNCTION_DESCRIPTION_COMMON_1 = "Selects an item from the input sequence $arg whose value is less than or equal to the value of every other item in the input sequence. If there are two or more such items, then the specific item whose value is returned is implementation dependent.\n\nThe following rules are applied to the input sequence:\n\n- Values of type xs:untypedAtomic in $arg are cast to xs:double.\n- Numeric and xs:anyURI values are converted to the least common type that supports the 'le' operator by a combination of type promotion and subtype substitution. See Section B.1 Type PromotionXP and Section B.2 Operator MappingXP.\n\nThe items in the resulting sequence may be reordered in an arbitrary order. The resulting sequence is referred to below as the converted sequence. This function returns an item from the converted sequence rather than the input sequence.\n\nIf the converted sequence is empty, the empty sequence is returned.\n\nAll items in $arg must be numeric or derived from a single base type for which the 'le' operator is defined. In addition, the values in the sequence must have a total order. If date/time values do not have a timezone, they are considered to have the implicit timezone provided by the dynamic context for the purpose of comparison. Duration values must either all be xs:yearMonthDuration values or must all be xs:dayTimeDuration values.\n\nIf any of these conditions is not met, a type error is raised [err:FORG0006].\n\nIf the converted sequence contains the value NaN, the value NaN is returned.\n\nIf the items in the value of $arg are of type xs:string or types derived by restriction from xs:string, then the determination of the item with the smallest value is made according to the collation that is used. ";
    protected static final String FUNCTION_DESCRIPTION_2_PARAM = "If the type of the items in $arg is not xs:string and $collation is specified, the collation is ignored.\n\n";
    protected static final String FUNCTION_DESCRIPTION_COMMON_2 = "The collation used by the invocation of this function is determined according to the rules in 7.3.1 Collations.";
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("min", "http://www.w3.org/2005/xpath-functions"), "Selects an item from the input sequence $arg whose value is less than or equal to the value of every other item in the input sequence. If there are two or more such items, then the specific item whose value is returned is implementation dependent.\n\nThe following rules are applied to the input sequence:\n\n- Values of type xs:untypedAtomic in $arg are cast to xs:double.\n- Numeric and xs:anyURI values are converted to the least common type that supports the 'le' operator by a combination of type promotion and subtype substitution. See Section B.1 Type PromotionXP and Section B.2 Operator MappingXP.\n\nThe items in the resulting sequence may be reordered in an arbitrary order. The resulting sequence is referred to below as the converted sequence. This function returns an item from the converted sequence rather than the input sequence.\n\nIf the converted sequence is empty, the empty sequence is returned.\n\nAll items in $arg must be numeric or derived from a single base type for which the 'le' operator is defined. In addition, the values in the sequence must have a total order. If date/time values do not have a timezone, they are considered to have the implicit timezone provided by the dynamic context for the purpose of comparison. Duration values must either all be xs:yearMonthDuration values or must all be xs:dayTimeDuration values.\n\nIf any of these conditions is not met, a type error is raised [err:FORG0006].\n\nIf the converted sequence contains the value NaN, the value NaN is returned.\n\nIf the items in the value of $arg are of type xs:string or types derived by restriction from xs:string, then the determination of the item with the smallest value is made according to the collation that is used. The collation used by the invocation of this function is determined according to the rules in 7.3.1 Collations.", new SequenceType[]{new FunctionParameterSequenceType("arg", 20, 7, "The input sequence")}, new FunctionReturnSequenceType(20, 3, "the minimum value")), new FunctionSignature(new QName("min", "http://www.w3.org/2005/xpath-functions"), "Selects an item from the input sequence $arg whose value is less than or equal to the value of every other item in the input sequence. If there are two or more such items, then the specific item whose value is returned is implementation dependent.\n\nThe following rules are applied to the input sequence:\n\n- Values of type xs:untypedAtomic in $arg are cast to xs:double.\n- Numeric and xs:anyURI values are converted to the least common type that supports the 'le' operator by a combination of type promotion and subtype substitution. See Section B.1 Type PromotionXP and Section B.2 Operator MappingXP.\n\nThe items in the resulting sequence may be reordered in an arbitrary order. The resulting sequence is referred to below as the converted sequence. This function returns an item from the converted sequence rather than the input sequence.\n\nIf the converted sequence is empty, the empty sequence is returned.\n\nAll items in $arg must be numeric or derived from a single base type for which the 'le' operator is defined. In addition, the values in the sequence must have a total order. If date/time values do not have a timezone, they are considered to have the implicit timezone provided by the dynamic context for the purpose of comparison. Duration values must either all be xs:yearMonthDuration values or must all be xs:dayTimeDuration values.\n\nIf any of these conditions is not met, a type error is raised [err:FORG0006].\n\nIf the converted sequence contains the value NaN, the value NaN is returned.\n\nIf the items in the value of $arg are of type xs:string or types derived by restriction from xs:string, then the determination of the item with the smallest value is made according to the collation that is used. If the type of the items in $arg is not xs:string and $collation is specified, the collation is ignored.\n\nThe collation used by the invocation of this function is determined according to the rules in 7.3.1 Collations.", new SequenceType[]{new FunctionParameterSequenceType("arg", 20, 7, "The input sequence"), new FunctionParameterSequenceType("collation-uri", 22, 2, "The collation URI")}, new FunctionReturnSequenceType(20, 3, "the minimum value"))};

    public FunMin(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        boolean computableProcessing = false;
        Sequence arg = this.getArgument(0).eval(contextSequence, contextItem);
        if (arg.isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            Collator collator = this.getCollator(contextSequence, contextItem, 2);
            SequenceIterator iter = arg.unorderedIterator();
            AtomicValue min = null;
            while (iter.hasNext()) {
                Item item = iter.nextItem();
                if (item instanceof QNameValue) {
                    throw new XPathException(this, ErrorCodes.FORG0006, "Cannot compare " + Type.getTypeName(item.getType()), arg);
                }
                AtomicValue value = item.atomize();
                if (Type.subTypeOf(value.getType(), 53)) {
                    if ((value = ((DurationValue)value).wrap()).getType() == 54) {
                        if (min != null && min.getType() != 54) {
                            throw new XPathException(this, ErrorCodes.FORG0006, "Cannot compare " + Type.getTypeName(min.getType()) + " and " + Type.getTypeName(value.getType()), value);
                        }
                    } else {
                        if (value.getType() != 55) throw new XPathException(this, ErrorCodes.FORG0006, "Cannot compare " + Type.getTypeName(value.getType()), value);
                        if (min != null && min.getType() != 55) {
                            throw new XPathException(this, ErrorCodes.FORG0006, "Cannot compare " + Type.getTypeName(min.getType()) + " and " + Type.getTypeName(value.getType()), value);
                        }
                    }
                } else if (value.getType() == 21) {
                    value = value.convertTo(34);
                }
                if (min == null) {
                    min = value;
                    continue;
                }
                if (Type.getCommonSuperType(min.getType(), value.getType()) == 20) {
                    throw new XPathException(this, ErrorCodes.FORG0006, "Cannot compare " + Type.getTypeName(min.getType()) + " and " + Type.getTypeName(value.getType()), value);
                }
                if (value.getType() == 20) {
                    value = value.convertTo(34);
                }
                if (Type.subTypeOf(value.getType(), 30)) {
                    if (!Type.subTypeOf(min.getType(), 30)) {
                        throw new XPathException(this, ErrorCodes.FORG0006, "Cannot compare " + Type.getTypeName(min.getType()) + " and " + Type.getTypeName(value.getType()), min);
                    }
                    if (((NumericValue)value).isNaN()) {
                        if ((value = value.promote(min)).getType() == 33) {
                            min = FloatValue.NaN;
                            continue;
                        }
                        min = DoubleValue.NaN;
                        continue;
                    }
                    min = min.promote(value);
                }
                if (value instanceof ComputableValue) {
                    if (!(min instanceof ComputableValue)) {
                        throw new XPathException(this, ErrorCodes.FORG0006, "Cannot compare " + Type.getTypeName(min.getType()) + " and " + Type.getTypeName(value.getType()), min);
                    }
                    value = value.promote(min);
                    min = min.min(collator, value);
                    computableProcessing = true;
                    continue;
                }
                if (computableProcessing) {
                    throw new XPathException(this, ErrorCodes.FORG0006, "Cannot compare " + Type.getTypeName(min.getType()) + " and " + Type.getTypeName(value.getType()), value);
                }
                if (Collations.compare(collator, value.getStringValue(), min.getStringValue()) >= 0) continue;
                min = value;
            }
            result = min;
        }
        if (!this.context.getProfiler().isEnabled()) return result;
        this.context.getProfiler().end(this, "", result);
        return result;
    }
}

