/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import java.util.Map;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.fn.FunInScopePrefixes;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunNamespaceURIForPrefix
extends BasicFunction {
    protected static final String FUNCTION_DESCRIPTION = "Returns the namespace URI of one of the in-scope namespaces for $element, identified by its namespace prefix.\n\nIf $element has an in-scope namespace whose namespace prefix is equal to $prefix, it returns the namespace URI of that namespace. If $prefix is the zero-length string or the empty sequence, it returns the namespace URI of the default (unnamed) namespace. Otherwise, it returns the empty sequence.\n\nPrefixes are equal only if their Unicode code points match exactly.";
    public static final FunctionSignature signature = new FunctionSignature(new QName("namespace-uri-for-prefix", "http://www.w3.org/2005/xpath-functions"), "Returns the namespace URI of one of the in-scope namespaces for $element, identified by its namespace prefix.\n\nIf $element has an in-scope namespace whose namespace prefix is equal to $prefix, it returns the namespace URI of that namespace. If $prefix is the zero-length string or the empty sequence, it returns the namespace URI of the default (unnamed) namespace. Otherwise, it returns the empty sequence.\n\nPrefixes are equal only if their Unicode code points match exactly.", new SequenceType[]{new FunctionParameterSequenceType("prefix", 22, 3, "The namespace prefix"), new FunctionParameterSequenceType("element", 1, 2, "The element")}, new FunctionReturnSequenceType(25, 3, "the namespace URI"));

    public FunNamespaceURIForPrefix(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String namespace;
        String prefix;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        if ("xml".equals(prefix = args[0].isEmpty() ? "" : args[0].itemAt(0).getStringValue())) {
            namespace = "http://www.w3.org/XML/1998/namespace";
        } else {
            Map<String, String> prefixes = FunInScopePrefixes.collectPrefixes(this.context, (NodeValue)args[1].itemAt(0));
            namespace = prefixes.get(prefix);
        }
        Sequence result = namespace == null ? Sequence.EMPTY_SEQUENCE : new AnyURIValue(namespace);
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

