/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import org.exist.dom.INode;
import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.QNameValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.w3c.dom.Node;

public class FunNodeName
extends Function {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("node-name", "http://www.w3.org/2005/xpath-functions"), "Returns an expanded-QName for node kinds that can have names. For other kinds of nodes it returns the empty sequence. If the context item is the empty sequence, the empty sequence is returned.", new SequenceType[0], new FunctionReturnSequenceType(24, 3, "the expanded QName")), new FunctionSignature(new QName("node-name", "http://www.w3.org/2005/xpath-functions"), "Returns an expanded-QName for node kinds that can have names. For other kinds of nodes it returns the empty sequence. If $arg is the empty sequence, the empty sequence is returned.", new SequenceType[]{new FunctionParameterSequenceType("arg", -1, 3, "The input node")}, new FunctionReturnSequenceType(24, 3, "the expanded QName"))};

    public FunNodeName(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        Sequence seq;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if ((seq = this.getSignature().getArgumentCount() > 0 ? this.getArgument(0).eval(contextSequence, contextItem) : contextSequence) == null) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Undefined context item");
        }
        if (seq.isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            QName qn;
            Item item = seq.itemAt(0);
            if (!Type.subTypeOf(item.getType(), -1)) {
                throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "item is not a node; got '" + Type.getTypeName(item.getType()) + "'");
            }
            Node n = ((NodeValue)item).getNode();
            result = n instanceof INode ? ((qn = ((INode)n).getQName()).equals(QName.EMPTY_QNAME) ? Sequence.EMPTY_SEQUENCE : new QNameValue(this.context, qn)) : Sequence.EMPTY_SEQUENCE;
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

