/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import java.text.Normalizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class FunNormalizeUnicode
extends Function {
    protected static final Logger logger = LogManager.getLogger(FunNormalizeUnicode.class);
    protected static final String FUNCTION_DESCRIPTION_0_PARAM = "Returns the value of the context item normalized according to the nomalization form \"NFC\"\n\n";
    protected static final String FUNCTION_DESCRIPTION_1_PARAM = "Returns the value of $arg normalized according to the normalization criteria for a normalization form identified by the value of $normalization-form. The effective value of the $normalization-form is computed by removing leading and trailing blanks, if present, and converting to upper case.\n\nIf the value of $arg is the empty sequence, returns the zero-length string.\n\nSee [Character Model for the World Wide Web 1.0: Normalization] for a description of the normalization forms.\n\n- If the effective value of $normalization-form is \"NFC\", then the value returned by the function is the value of $arg in Unicode Normalization Form C (NFC).\n- If the effective value of $normalization-form is \"NFD\", then the value returned by the function is the value of $arg in Unicode Normalization Form D (NFD).\n- If the effective value of $normalization-form is \"NFKC\", then the value returned by the function is the value of $arg in Unicode Normalization Form KC (NFKC).\n- If the effective value of $normalization-form is \"NFKD\", then the value returned by the function is the value of $arg in Unicode Normalization Form KD (NFKD).\n- If the effective value of $normalization-form is \"FULLY-NORMALIZED\", then the value returned by the function is the value of $arg in the fully normalized form.\n- If the effective value of $normalization-form is the zero-length string, no normalization is performed and $arg is returned.\n\nConforming implementations must support normalization form \"NFC\" and may support normalization forms \"NFD\", \"NFKC\", \"NFKD\", \"FULLY-NORMALIZED\". They may also support other normalization forms with implementation-defined semantics. If the effective value of the $normalization-form is other than one of the values supported by the implementation, then an error is raised [err:FOCH0003].";
    protected static final FunctionParameterSequenceType ARG_PARAM = new FunctionParameterSequenceType("arg", 22, 3, "The unicode string to normalize");
    protected static final FunctionParameterSequenceType NF_PARAM = new FunctionParameterSequenceType("normalization-form", 22, 2, "The normalization form");
    protected static final FunctionReturnSequenceType RETURN_TYPE = new FunctionReturnSequenceType(22, 2, "the normalized text");
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("normalize-unicode", "http://www.w3.org/2005/xpath-functions"), "Returns the value of the context item normalized according to the nomalization form \"NFC\"\n\n", new SequenceType[]{ARG_PARAM}, RETURN_TYPE), new FunctionSignature(new QName("normalize-unicode", "http://www.w3.org/2005/xpath-functions"), "Returns the value of $arg normalized according to the normalization criteria for a normalization form identified by the value of $normalization-form. The effective value of the $normalization-form is computed by removing leading and trailing blanks, if present, and converting to upper case.\n\nIf the value of $arg is the empty sequence, returns the zero-length string.\n\nSee [Character Model for the World Wide Web 1.0: Normalization] for a description of the normalization forms.\n\n- If the effective value of $normalization-form is \"NFC\", then the value returned by the function is the value of $arg in Unicode Normalization Form C (NFC).\n- If the effective value of $normalization-form is \"NFD\", then the value returned by the function is the value of $arg in Unicode Normalization Form D (NFD).\n- If the effective value of $normalization-form is \"NFKC\", then the value returned by the function is the value of $arg in Unicode Normalization Form KC (NFKC).\n- If the effective value of $normalization-form is \"NFKD\", then the value returned by the function is the value of $arg in Unicode Normalization Form KD (NFKD).\n- If the effective value of $normalization-form is \"FULLY-NORMALIZED\", then the value returned by the function is the value of $arg in the fully normalized form.\n- If the effective value of $normalization-form is the zero-length string, no normalization is performed and $arg is returned.\n\nConforming implementations must support normalization form \"NFC\" and may support normalization forms \"NFD\", \"NFKC\", \"NFKD\", \"FULLY-NORMALIZED\". They may also support other normalization forms with implementation-defined semantics. If the effective value of the $normalization-form is other than one of the values supported by the implementation, then an error is raised [err:FOCH0003].", new SequenceType[]{ARG_PARAM, NF_PARAM}, RETURN_TYPE)};

    public FunNormalizeUnicode(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        StringValue result;
        Sequence s1;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if ((s1 = this.getArgument(0).eval(contextSequence)).isEmpty()) {
            result = StringValue.EMPTY_STRING;
        } else {
            String newNormalizationForm = "NFC";
            if (this.getArgumentCount() > 1) {
                newNormalizationForm = this.getArgument(1).eval(contextSequence).getStringValue().toUpperCase().trim();
            }
            if ("".equals(newNormalizationForm)) {
                result = new StringValue(s1.getStringValue());
            } else {
                try {
                    Normalizer.Form form = Normalizer.Form.valueOf(newNormalizationForm);
                    result = new StringValue(Normalizer.normalize(s1.getStringValue(), form));
                }
                catch (IllegalArgumentException e) {
                    throw new XPathException((Expression)this, ErrorCodes.FOCH0003, "Unknown normalization form: " + newNormalizationForm);
                }
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

