/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunNumber
extends Function {
    protected static final String FUNCTION_DESCRIPTION_0_PARAM = "Returns the value of the context item after atomization, converted to an xs:double.\n\nIf the context item cannot be converted to an xs:double, the xs:double value NaN is returned. If the context item is undefined an error is raised: [err:XPDY0002]XP.\n\n";
    protected static final String FUNCTION_DESCRIPTION_1_PARAM = "Returns the value indicated by $arg or, if $arg is not specified, the context item after atomization, converted to an xs:double.\n\nCalling the zero-argument version of the function is defined to give the same result as calling the single-argument version with the context item (.). That is, fn:number() is equivalent to fn:number(.).\n\nIf $arg is the empty sequence or if $arg or the context item cannot be converted to an xs:double, the xs:double value NaN is returned. If the context item is undefined an error is raised: [err:XPDY0002]XP.\n\nIf $arg is the empty sequence, NaN is returned. Otherwise, $arg, or the context item after atomization, is converted to an xs:double following the rules of 17.1.3.2 Casting to xs:double. If the conversion to xs:double fails, the xs:double value NaN is returned.";
    protected static final FunctionParameterSequenceType ARG_PARAM = new FunctionParameterSequenceType("arg", 20, 3, "The input item");
    protected static final FunctionReturnSequenceType RETURN_TYPE = new FunctionReturnSequenceType(34, 2, "the numerical value");
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("number", "http://www.w3.org/2005/xpath-functions"), "Returns the value of the context item after atomization, converted to an xs:double.\n\nIf the context item cannot be converted to an xs:double, the xs:double value NaN is returned. If the context item is undefined an error is raised: [err:XPDY0002]XP.\n\n", new SequenceType[0], RETURN_TYPE), new FunctionSignature(new QName("number", "http://www.w3.org/2005/xpath-functions"), "Returns the value indicated by $arg or, if $arg is not specified, the context item after atomization, converted to an xs:double.\n\nCalling the zero-argument version of the function is defined to give the same result as calling the single-argument version with the context item (.). That is, fn:number() is equivalent to fn:number(.).\n\nIf $arg is the empty sequence or if $arg or the context item cannot be converted to an xs:double, the xs:double value NaN is returned. If the context item is undefined an error is raised: [err:XPDY0002]XP.\n\nIf $arg is the empty sequence, NaN is returned. Otherwise, $arg, or the context item after atomization, is converted to an xs:double following the rules of 17.1.3.2 Casting to xs:double. If the conversion to xs:double fails, the xs:double value NaN is returned.", new SequenceType[]{ARG_PARAM}, RETURN_TYPE)};

    public FunNumber(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        Sequence arg = null;
        if (this.getSignature().getArgumentCount() == 1) {
            arg = this.getArgument(0).eval(contextSequence);
            if (arg.isEmpty()) {
                result = DoubleValue.NaN;
            } else {
                try {
                    result = arg.convertTo(34);
                }
                catch (XPathException e) {
                    result = DoubleValue.NaN;
                }
            }
        } else {
            if (contextSequence == null) {
                throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Undefined context item");
            }
            arg = contextSequence;
            if (arg.isEmpty()) {
                result = Sequence.EMPTY_SEQUENCE;
            } else {
                try {
                    result = arg.convertTo(34);
                }
                catch (XPathException e) {
                    result = DoubleValue.NaN;
                }
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

