/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import org.exist.dom.QName;
import org.exist.util.XMLChar;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.QNameValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public class FunQName
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("QName", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:QName with the namespace URI given in $uri. If $uri is the zero-length string or the empty sequence, it represents \"no namespace\"; in this case, if the value of $qname contains a colon (:), an error is raised [err:FOCA0002]. The prefix (or absence of a prefix) in $qname is retained in the returned xs:QName value. The local name in the result is taken from the local part of $qname.\n\nIf $qname does not have the correct lexical form for xs:QName an error is raised [err:FOCA0002].\n\nNote that unlike xs:QName this function does not require a xs:string literal as the argument.", new SequenceType[]{new FunctionParameterSequenceType("uri", 22, 3, "The namespace URI"), new FunctionParameterSequenceType("qname", 22, 2, "The prefix")}, new FunctionReturnSequenceType(24, 2, "the xs:QName with the namespace URI given in $uri"));

    public FunQName(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        if (!args[0].isEmpty() && args[0].getItemType() != 22) {
            throw new XPathException(this, ErrorCodes.XPTY0004, "Namespace URI is of type '" + Type.getTypeName(args[0].getItemType()) + "', 'xs:string' expected", args[0]);
        }
        String namespace = args[0].isEmpty() ? "" : args[0].getStringValue();
        String param = args[1].getStringValue();
        String prefix = null;
        String localName = null;
        try {
            prefix = QName.extractPrefix(param);
            localName = QName.extractLocalName(param);
        }
        catch (QName.IllegalQNameException e) {
            ValueSequence argsSeq = new ValueSequence(args[0]);
            argsSeq.addAll(args[1]);
            throw new XPathException(this, ErrorCodes.FOCA0002, "Invalid lexical form of either prefix or local name.", argsSeq);
        }
        if (prefix != null && prefix.length() > 0 && (namespace == null || namespace.length() == 0)) {
            ValueSequence argsSeq = new ValueSequence(args[0]);
            argsSeq.addAll(args[1]);
            throw new XPathException(this, ErrorCodes.FOCA0002, "Non-empty namespace prefix with empty namespace URI", argsSeq);
        }
        if (namespace != null) {
            if (namespace.equalsIgnoreCase("http://www.w3.org/2000/xmlns/")) {
                if (prefix == null) {
                    throw new XPathException((Expression)this, ErrorCodes.XQDY0044, "'http://www.w3.org/2000/xmlns/' can't be use with no prefix");
                }
                if (!prefix.equalsIgnoreCase("xmlns")) {
                    throw new XPathException((Expression)this, ErrorCodes.XQDY0044, "'http://www.w3.org/2000/xmlns/' can't be use with prefix '" + prefix + "'");
                }
            }
            if (namespace.equalsIgnoreCase("http://www.w3.org/XML/1998/namespace")) {
                if (prefix == null) {
                    throw new XPathException((Expression)this, ErrorCodes.XQDY0044, "'http://www.w3.org/XML/1998/namespace' can't be use with no prefix");
                }
                if (!prefix.equalsIgnoreCase("xml")) {
                    throw new XPathException((Expression)this, ErrorCodes.XQDY0044, "'http://www.w3.org/XML/1998/namespace' can't be use with prefix '" + prefix + "'");
                }
            }
        }
        if (prefix != null && prefix.equalsIgnoreCase("xml") && !namespace.equalsIgnoreCase("http://www.w3.org/XML/1998/namespace")) {
            throw new XPathException((Expression)this, ErrorCodes.XQDY0044, "prefix 'xml' can be used only with 'http://www.w3.org/XML/1998/namespace'");
        }
        QName qname = new QName(localName, namespace, prefix);
        if (prefix != null && namespace != null && this.context.getURIForPrefix(prefix) == null) {
            this.context.declareNamespace(prefix, namespace);
        }
        if (!XMLChar.isValidName(qname.getLocalPart())) {
            throw new XPathException((Expression)this, ErrorCodes.FOCA0002, "'" + qname.getLocalPart() + "' is not a valid local name.");
        }
        QNameValue result = new QNameValue(this.context, qname);
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

