/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import java.util.Iterator;
import org.exist.dom.QName;
import org.exist.dom.memtree.NodeImpl;
import org.exist.dom.persistent.ElementImpl;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeSet;
import org.exist.dom.persistent.NodeSetIterator;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.EmptySequence;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.QNameValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.w3c.dom.Element;

public class FunResolveQName
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("resolve-QName", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:QName value (that is, an expanded-QName) by taking an xs:string that has the lexical form of an xs:QName (a string in the form \"prefix:local-name\" or \"local-name\") and resolving it using the in-scope namespaces for a given element.\n\nIf $qname does not have the correct lexical form for xs:QName an error is raised [err:FOCA0002].\n\nIf $qname is the empty sequence, returns the empty sequence.\n\nMore specifically, the function searches the namespace bindings of $element for a binding whose name matches the prefix of $qname, or the zero-length string if it has no prefix, and constructs an expanded-QName whose local name is taken from the supplied $qname, and whose namespace URI is taken from the string value of the namespace binding.\n\nIf the $qname has a prefix and if there is no namespace binding for $element that matches this prefix, then an error is raised [err:FONS0004].\n\nIf the $qname has no prefix, and there is no namespace binding for $element corresponding to the default (unnamed) namespace, then the resulting expanded-QName has no namespace part.\n\nThe prefix (or absence of a prefix) in the supplied $qname argument is retained in the returned expanded-QName.", new SequenceType[]{new FunctionParameterSequenceType("qname", 22, 3, "The QName name"), new FunctionParameterSequenceType("element", 1, 2, "The element")}, new FunctionReturnSequenceType(24, 2, "the QName of $element with lexical form $qname"));

    public FunResolveQName(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence qnameSeq;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        if ((qnameSeq = args[0]).isEmpty()) {
            return EmptySequence.EMPTY_SEQUENCE;
        }
        this.context.pushInScopeNamespaces();
        String qnameString = args[0].getStringValue();
        if (QName.isQName(qnameString) == QName.Validity.VALID.val) {
            try {
                String prefix = QName.extractPrefix(qnameString);
                if (prefix == null) {
                    prefix = "";
                }
                String uri = null;
                NodeValue node = (NodeValue)args[1].itemAt(0);
                if (node.getImplementationType() == 1) {
                    ElementImpl e;
                    NodeProxy proxy = (NodeProxy)node;
                    NodeSet ancestors = proxy.getAncestors(this.contextId, true);
                    NodeSetIterator i = ancestors.iterator();
                    while (i.hasNext() && (uri = this.findNamespaceURI(e = (ElementImpl)(proxy = (NodeProxy)i.next()).getNode(), prefix)) == null) {
                    }
                } else {
                    NodeImpl next = (NodeImpl)node;
                    while ((uri = FunResolveQName.findNamespaceURI((org.exist.dom.memtree.ElementImpl)next, prefix)) == null && (next = (NodeImpl)next.getParentNode()) != null && next.getNodeType() == 1) {
                    }
                }
                if (uri == null && prefix != null && !"".equals(prefix)) {
                    throw new XPathException(this, ErrorCodes.FONS0004, "No namespace found for prefix. No binding for prefix '" + prefix + "' was found.", args[0]);
                }
                String localPart = QName.extractLocalName(qnameString);
                QName qn = new QName(localPart, uri, prefix);
                QNameValue result = new QNameValue(this.context, qn);
                if (this.context.getProfiler().isEnabled()) {
                    this.context.getProfiler().end(this, "", result);
                }
                this.context.popInScopeNamespaces();
                return result;
            }
            catch (QName.IllegalQNameException e) {
                throw new XPathException(this, ErrorCodes.FOCA0002, "Invalid lexical value. '" + qnameString + "' is not a QName.", args[0]);
            }
        }
        throw new XPathException(this, ErrorCodes.FOCA0002, "Invalid lexical value. '" + qnameString + "' is not a QName.", args[0]);
    }

    public String findNamespaceURI(ElementImpl element, String prefix) {
        String namespaceURI = element.getNamespaceURI();
        if (namespaceURI != null && namespaceURI.length() > 0 && prefix.equals(element.getPrefix())) {
            return namespaceURI;
        }
        if (element.declaresNamespacePrefixes()) {
            Iterator<String> i = element.getPrefixes();
            while (i.hasNext()) {
                String elementPrefix = i.next();
                this.context.declareInScopeNamespace(elementPrefix, element.getNamespaceForPrefix(elementPrefix));
                if (!prefix.equals(elementPrefix)) continue;
                return element.getNamespaceForPrefix(prefix);
            }
        }
        return null;
    }

    public static String findNamespaceURI(Element element, String prefix) {
        String namespaceURI = element.getNamespaceURI();
        if (namespaceURI != null && namespaceURI.length() > 0 && prefix.equals(element.getPrefix())) {
            return namespaceURI;
        }
        return null;
    }

    public static String findNamespaceURI(org.exist.dom.memtree.ElementImpl element, String prefix) {
        String namespaceURI = element.getNamespaceURI();
        if (namespaceURI != null && namespaceURI.length() > 0 && prefix.equals(element.getPrefix())) {
            return namespaceURI;
        }
        if (element.declaresNamespacePrefixes()) {
            return element.getNamespaceMap().get(prefix);
        }
        return null;
    }
}

