/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import java.net.URI;
import java.net.URISyntaxException;
import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunResolveURI
extends Function {
    protected static final String FUNCTION_DESCRIPTION_1_PARAM = "Resolves $relative against the value of the base-uri property from the static context ";
    protected static final String FUNCTION_DESCRIPTION_2_PARAM = "Resolves $relative against $base ";
    protected static final String FUNCTION_DESCRIPTION_COMMON = "using an algorithm such as the ones described in [RFC 2396] or [RFC 3986], and the resulting absolute URI reference is returned. An error may be raised [err:FORG0009] in the resolution process.\n\nIf $relative is an absolute URI reference, it is returned unchanged.\n\nIf $relative or $base is not a valid xs:anyURI an error is raised [err:FORG0002].\n\nIf $relative is the empty sequence, the empty sequence is returned.";
    protected static final FunctionParameterSequenceType RELATIVE_ARG = new FunctionParameterSequenceType("relative", 22, 3, "The relative URI");
    protected static final FunctionParameterSequenceType BASE_ARG = new FunctionParameterSequenceType("base", 22, 2, "The base URI");
    protected static final FunctionReturnSequenceType RETURN_TYPE = new FunctionReturnSequenceType(25, 3, "the absolute URI");
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("resolve-uri", "http://www.w3.org/2005/xpath-functions"), "Resolves $relative against the value of the base-uri property from the static context using an algorithm such as the ones described in [RFC 2396] or [RFC 3986], and the resulting absolute URI reference is returned. An error may be raised [err:FORG0009] in the resolution process.\n\nIf $relative is an absolute URI reference, it is returned unchanged.\n\nIf $relative or $base is not a valid xs:anyURI an error is raised [err:FORG0002].\n\nIf $relative is the empty sequence, the empty sequence is returned.", new SequenceType[]{RELATIVE_ARG}, RETURN_TYPE), new FunctionSignature(new QName("resolve-uri", "http://www.w3.org/2005/xpath-functions"), "Resolves $relative against $base using an algorithm such as the ones described in [RFC 2396] or [RFC 3986], and the resulting absolute URI reference is returned. An error may be raised [err:FORG0009] in the resolution process.\n\nIf $relative is an absolute URI reference, it is returned unchanged.\n\nIf $relative or $base is not a valid xs:anyURI an error is raised [err:FORG0002].\n\nIf $relative is the empty sequence, the empty sequence is returned.", new SequenceType[]{RELATIVE_ARG, BASE_ARG}, RETURN_TYPE)};

    public FunResolveURI(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        AnyURIValue base;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if (this.getArgumentCount() == 1) {
            if (!this.context.isBaseURIDeclared()) {
                throw new XPathException((Expression)this, ErrorCodes.FONS0005, "base URI of the static context has not been assigned a value.");
            }
            base = this.context.getBaseURI();
        } else {
            try {
                AtomicValue item = this.getArgument(1).eval(contextSequence).itemAt(0).convertTo(25);
                base = (AnyURIValue)item;
            }
            catch (XPathException e) {
                throw new XPathException(this, ErrorCodes.FORG0002, "invalid argument to fn:resolve-uri(): " + e.getMessage(), null, e);
            }
        }
        Sequence seq = this.getArgument(0).eval(contextSequence);
        if (seq.isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            URI baseURI;
            URI relativeURI;
            AnyURIValue relative;
            try {
                AtomicValue item = seq.itemAt(0).convertTo(25);
                relative = (AnyURIValue)item;
            }
            catch (XPathException e) {
                throw new XPathException(this, ErrorCodes.FORG0002, "invalid argument to fn:resolve-uri(): " + e.getMessage(), seq, e);
            }
            try {
                relativeURI = new URI(relative.getStringValue());
                baseURI = new URI(base.getStringValue());
            }
            catch (URISyntaxException e) {
                throw new XPathException(this, ErrorCodes.FORG0009, "unable to resolve a relative URI against a base URI in fn:resolve-uri(): " + e.getMessage(), null, e);
            }
            result = relativeURI.isAbsolute() ? relative : new AnyURIValue(baseURI.resolve(relativeURI));
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

