/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunRoundHalfToEven
extends Function {
    protected static final String FUNCTION_DESCRIPTION_1_PARAM = "The value returned is the nearest (that is, numerically closest) value to $arg that is a multiple of ten to the power of minus 0. ";
    protected static final String FUNCTION_DESCRIPTION_2_PARAM = "The value returned is the nearest (that is, numerically closest) value to $arg that is a multiple of ten to the power of minus $precision. ";
    protected static final String FUNCTION_DESCRIPTION_COMMON = "If two such values are equally near (e.g. if the fractional part in $arg is exactly .500...), the function returns the one whose least significant digit is even.\n\nIf the type of $arg is one of the four numeric types xs:float, xs:double, xs:decimal or xs:integer the type of the result is the same as the type of $arg. If the type of $arg is a type derived from one of the numeric types, the result is an instance of the base numeric type.\n\nThe three argument version of the function with $precision = 0 produces the same result as the two argument version.\n\nFor arguments of type xs:float and xs:double, if the argument is NaN, positive or negative zero, or positive or negative infinity, then the result is the same as the argument. In all other cases, the argument is cast to xs:decimal, the function is applied to this xs:decimal value, and the resulting xs:decimal is cast back to xs:float or xs:double as appropriate to form the function result. If the resulting xs:decimal value is zero, then positive or negative zero is returned according to the sign of the original argument.\n\nNote that the process of casting to xs:decimal may result in an error [err:FOCA0001].\n\nIf $arg is of type xs:float or xs:double, rounding occurs on the value of the mantissa computed with exponent = 0.";
    protected static final FunctionParameterSequenceType ARG_PARAM = new FunctionParameterSequenceType("arg", 30, 3, "The input number");
    protected static final FunctionParameterSequenceType PRECISION_PARAM = new FunctionParameterSequenceType("precision", 30, 3, "The precision factor");
    protected static final FunctionReturnSequenceType RETURN_TYPE = new FunctionReturnSequenceType(30, 2, "the rounded value");
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("round-half-to-even", "http://www.w3.org/2005/xpath-functions"), "The value returned is the nearest (that is, numerically closest) value to $arg that is a multiple of ten to the power of minus 0. If two such values are equally near (e.g. if the fractional part in $arg is exactly .500...), the function returns the one whose least significant digit is even.\n\nIf the type of $arg is one of the four numeric types xs:float, xs:double, xs:decimal or xs:integer the type of the result is the same as the type of $arg. If the type of $arg is a type derived from one of the numeric types, the result is an instance of the base numeric type.\n\nThe three argument version of the function with $precision = 0 produces the same result as the two argument version.\n\nFor arguments of type xs:float and xs:double, if the argument is NaN, positive or negative zero, or positive or negative infinity, then the result is the same as the argument. In all other cases, the argument is cast to xs:decimal, the function is applied to this xs:decimal value, and the resulting xs:decimal is cast back to xs:float or xs:double as appropriate to form the function result. If the resulting xs:decimal value is zero, then positive or negative zero is returned according to the sign of the original argument.\n\nNote that the process of casting to xs:decimal may result in an error [err:FOCA0001].\n\nIf $arg is of type xs:float or xs:double, rounding occurs on the value of the mantissa computed with exponent = 0.", new SequenceType[]{ARG_PARAM}, RETURN_TYPE), new FunctionSignature(new QName("round-half-to-even", "http://www.w3.org/2005/xpath-functions"), "The value returned is the nearest (that is, numerically closest) value to $arg that is a multiple of ten to the power of minus $precision. If two such values are equally near (e.g. if the fractional part in $arg is exactly .500...), the function returns the one whose least significant digit is even.\n\nIf the type of $arg is one of the four numeric types xs:float, xs:double, xs:decimal or xs:integer the type of the result is the same as the type of $arg. If the type of $arg is a type derived from one of the numeric types, the result is an instance of the base numeric type.\n\nThe three argument version of the function with $precision = 0 produces the same result as the two argument version.\n\nFor arguments of type xs:float and xs:double, if the argument is NaN, positive or negative zero, or positive or negative infinity, then the result is the same as the argument. In all other cases, the argument is cast to xs:decimal, the function is applied to this xs:decimal value, and the resulting xs:decimal is cast back to xs:float or xs:double as appropriate to form the function result. If the resulting xs:decimal value is zero, then positive or negative zero is returned according to the sign of the original argument.\n\nNote that the process of casting to xs:decimal may result in an error [err:FOCA0001].\n\nIf $arg is of type xs:float or xs:double, rounding occurs on the value of the mantissa computed with exponent = 0.", new SequenceType[]{ARG_PARAM, PRECISION_PARAM}, RETURN_TYPE)};

    public FunRoundHalfToEven(XQueryContext context, FunctionSignature signatures) {
        super(context, signatures);
    }

    @Override
    public int returnsType() {
        return 34;
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        IntegerValue precision = null;
        Sequence seq = this.getArgument(0).eval(contextSequence, contextItem);
        if (seq.isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            Item item;
            if (contextItem != null) {
                contextSequence = contextItem.toSequence();
            }
            if (this.getSignature().getArgumentCount() > 1) {
                precision = (IntegerValue)this.getArgument(1).eval(contextSequence, contextItem).itemAt(0).convertTo(31);
            }
            NumericValue value = (item = seq.itemAt(0)) instanceof NumericValue ? (NumericValue)item : (NumericValue)item.convertTo(30);
            result = value.round(precision);
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

