/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import org.exist.dom.QName;
import org.exist.util.Collations;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Atomize;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Constants;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.ValueComparison;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.fn.FunDeepEqual;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReference;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public class FunSort
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("sort", "http://www.w3.org/2005/xpath-functions"), "Sorts a supplied sequence.", new SequenceType[]{new FunctionParameterSequenceType("input", 11, 7, "")}, new FunctionReturnSequenceType(11, 7, "the first item or the empty sequence")), new FunctionSignature(new QName("sort", "http://www.w3.org/2005/xpath-functions"), "Sorts a supplied sequence, based on the value of a sort key supplied as a function.", new SequenceType[]{new FunctionParameterSequenceType("input", 11, 7, ""), new FunctionParameterSequenceType("collation", 22, 3, "")}, new FunctionReturnSequenceType(11, 7, "the resulting sequence")), new FunctionSignature(new QName("sort", "http://www.w3.org/2005/xpath-functions"), "Sorts a supplied sequence, based on the value of a sort key supplied as a function.", new SequenceType[]{new FunctionParameterSequenceType("input", 11, 7, ""), new FunctionParameterSequenceType("collation", 22, 3, ""), new FunctionParameterSequenceType("key", 101, 2, "")}, new FunctionReturnSequenceType(11, 7, "the resulting sequence"))};
    AnalyzeContextInfo cachedContextInfo;

    public FunSort(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        if (this.getContext().getXQueryVersion() < 31) {
            throw new XPathException((Expression)this, ErrorCodes.EXXQDY0003, "Function " + this.getSignature().getName() + " is only supported for xquery version \"3.1\" and later.");
        }
        this.cachedContextInfo = new AnalyzeContextInfo(contextInfo);
        super.analyze(this.cachedContextInfo);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence seq = args[0];
        Collator collator = this.collator(args, 1);
        FunctionReference ref = this.function(args, 2);
        ArrayList<Sequence> keys = new ArrayList<Sequence>(seq.getItemCount());
        Sequence[] refArgs = new Sequence[1];
        SequenceIterator i = seq.iterate();
        while (i.hasNext()) {
            Sequence value;
            Item item = i.nextItem();
            if (ref != null) {
                refArgs[0] = item.toSequence();
                value = ref.evalFunction(contextSequence, null, refArgs);
            } else {
                value = item.toSequence();
            }
            keys.add(Atomize.atomize(value));
        }
        return this.sort(seq, keys, collator);
    }

    private Sequence sort(Sequence seq, ArrayList<Sequence> keys, Collator collator) throws XPathException {
        Holder exception = new Holder();
        int size = seq.getItemCount();
        Integer[] order = new Integer[size];
        for (int i = 0; i < size; ++i) {
            order[i] = i;
        }
        try {
            Arrays.sort(order, (i1, i2) -> {
                Sequence seq1 = (Sequence)keys.get((int)i1);
                Sequence seq2 = (Sequence)keys.get((int)i2);
                int size1 = seq1.getItemCount();
                int size2 = seq2.getItemCount();
                int minSize = Math.min(size1, size2);
                if (size1 == 0) {
                    return -size2;
                }
                for (int pos = 0; pos < minSize; ++pos) {
                    Item item1 = seq1.itemAt(pos);
                    Item item2 = seq2.itemAt(pos);
                    int res = 0;
                    if (FunDeepEqual.deepEquals(item1, item2, collator)) continue;
                    if (Type.subTypeOf(item1.getType(), 30) && ((NumericValue)item1).isNaN()) {
                        res = -1;
                    } else if (Type.subTypeOf(item1.getType(), 22) && Type.subTypeOf(item2.getType(), 22)) {
                        try {
                            res = Collations.compare(collator, item1.getStringValue(), item2.getStringValue());
                        }
                        catch (XPathException e) {
                            exception.set(e);
                        }
                    } else if (item1 instanceof AtomicValue && item2 instanceof AtomicValue) {
                        try {
                            ValueComparison.compareAtomic(collator, (AtomicValue)item1, (AtomicValue)item2, Constants.StringTruncationOperator.NONE, Constants.Comparison.LT);
                            res = ((AtomicValue)item1).compareTo(collator, (AtomicValue)item2);
                        }
                        catch (XPathException e) {
                            exception.set(e);
                            throw new IllegalArgumentException();
                        }
                    } else {
                        res = -1;
                    }
                    if (res == 0) continue;
                    return res;
                }
                return size1 - size2;
            });
        }
        catch (IllegalArgumentException e) {
            if (exception.get() != null) {
                throw new XPathException((Expression)this, ErrorCodes.XPTY0004, (Throwable)exception.get());
            }
            throw new XPathException((Expression)this, ErrorCodes.XPTY0004, e.getMessage());
        }
        ValueSequence result = new ValueSequence(seq.getItemCount());
        result.keepUnOrdered(true);
        for (int i = 0; i < size; ++i) {
            result.add(seq.itemAt(order[i]));
        }
        return result;
    }

    private Collator collator(Sequence[] args, int pos) throws XPathException {
        if (args.length > pos) {
            if (args[pos].isEmpty()) {
                return this.context.getDefaultCollator();
            }
            String collationURI = args[pos].getStringValue();
            return this.context.getCollator(collationURI);
        }
        return this.context.getDefaultCollator();
    }

    private FunctionReference function(Sequence[] args, int pos) throws XPathException {
        if (args.length > pos) {
            FunctionReference ref = (FunctionReference)args[2].itemAt(0);
            if (ref != null) {
                ref.analyze(new AnalyzeContextInfo(this.cachedContextInfo));
            }
            return ref;
        }
        return null;
    }

    static class Holder<T> {
        T obj;

        Holder() {
        }

        public void set(T obj) {
            this.obj = obj;
        }

        public T get() {
            return this.obj;
        }
    }
}

