/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import com.ibm.icu.text.Collator;
import org.exist.dom.QName;
import org.exist.util.Collations;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.fn.CollatingFunction;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunStartsWith
extends CollatingFunction {
    protected static final String FUNCTION_DESCRIPTION = "Returns an xs:boolean indicating whether or not the value of $source starts with a sequence of collation units that provides a minimal match to the collation units of $prefix according to the collation that is used.\n\nNote:\n\n\"Minimal match\" is defined in [Unicode Collation Algorithm].\n\nIf the value of $source or $prefix is the empty sequence, or contains only ignorable collation units, it is interpreted as the zero-length string.\n\nIf the value of $prefix is the zero-length string, then the function returns true. If the value of $source is the zero-length string and the value of $prefix is not the zero-length string, then the function returns false.\n\nThe collation used by the invocation of this function is determined according to the rules in 7.3.1 Collations. If the specified collation does not support collation units an error may be raised [err:FOCH0004]. ";
    protected static final FunctionParameterSequenceType ARG1_PARAM = new FunctionParameterSequenceType("source", 22, 3, "The source string");
    protected static final FunctionParameterSequenceType ARG2_PARAM = new FunctionParameterSequenceType("prefix", 22, 3, "The string to determine if is a prefix of $source");
    protected static final FunctionParameterSequenceType COLLATION_PARAM = new FunctionParameterSequenceType("collation-uri", 22, 2, "The collation URI");
    protected static final FunctionReturnSequenceType RETURN_TYPE = new FunctionReturnSequenceType(23, 3, "true if $prefix is a prefix of the string $source");
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("starts-with", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:boolean indicating whether or not the value of $source starts with a sequence of collation units that provides a minimal match to the collation units of $prefix according to the collation that is used.\n\nNote:\n\n\"Minimal match\" is defined in [Unicode Collation Algorithm].\n\nIf the value of $source or $prefix is the empty sequence, or contains only ignorable collation units, it is interpreted as the zero-length string.\n\nIf the value of $prefix is the zero-length string, then the function returns true. If the value of $source is the zero-length string and the value of $prefix is not the zero-length string, then the function returns false.\n\nThe collation used by the invocation of this function is determined according to the rules in 7.3.1 Collations. If the specified collation does not support collation units an error may be raised [err:FOCH0004]. ", new SequenceType[]{ARG1_PARAM, ARG2_PARAM}, RETURN_TYPE), new FunctionSignature(new QName("starts-with", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:boolean indicating whether or not the value of $source starts with a sequence of collation units that provides a minimal match to the collation units of $prefix according to the collation that is used.\n\nNote:\n\n\"Minimal match\" is defined in [Unicode Collation Algorithm].\n\nIf the value of $source or $prefix is the empty sequence, or contains only ignorable collation units, it is interpreted as the zero-length string.\n\nIf the value of $prefix is the zero-length string, then the function returns true. If the value of $source is the zero-length string and the value of $prefix is not the zero-length string, then the function returns false.\n\nThe collation used by the invocation of this function is determined according to the rules in 7.3.1 Collations. If the specified collation does not support collation units an error may be raised [err:FOCH0004]. The third argument $collation-uri is either: 1) the full URI e.g. \"http://www.w3.org/2013/collation/UCA?lang=en;strength=secondary\", or 2) relative where you only need to specify the last part of a valid full collation-uri, e.g. \"?lang=sv-SE\", \"lang=sv-SE;strength=primary;decomposition=standard\" or \"swedish\".", new SequenceType[]{ARG1_PARAM, ARG2_PARAM, COLLATION_PARAM}, RETURN_TYPE)};

    public FunStartsWith(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Collator collator;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        String s1 = this.getArgument(0).eval(contextSequence).getStringValue();
        String s2 = this.getArgument(1).eval(contextSequence).getStringValue();
        Sequence result = s1.length() == 0 || s2.length() == 0 ? Sequence.EMPTY_SEQUENCE : (Collations.startsWith(collator = this.getCollator(contextSequence, contextItem, 3), s1, s2) ? BooleanValue.TRUE : BooleanValue.FALSE);
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

