/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.fn.FunStringToCodepoints;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunStrLength
extends Function {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("string-length", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:integer equal to the length in characters of the value of the context item.\nIf the context item is undefined an error is raised. ", new SequenceType[0], new FunctionReturnSequenceType(31, 3, "the length in characters")), new FunctionSignature(new QName("string-length", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:integer equal to the length in characters of the value of $arg.\nIf the value of $arg is the empty sequence, the xs:integer 0 is returned.\nIf no argument is supplied, $arg defaults to the string value (calculated using fn:string()) of the context item (.). If no argument is supplied or if the argument is the context item and the context item is undefined an error is raised", new SequenceType[]{new FunctionParameterSequenceType("arg", 22, 3, "The input string")}, new FunctionReturnSequenceType(31, 3, "the length in characters"))};

    public FunStrLength(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if (this.getSignature().getArgumentCount() == 1) {
            contextSequence = this.getArgument(0).eval(contextSequence);
        }
        if (contextSequence == null) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Undefined context item");
        }
        String strval = contextSequence.getStringValue();
        IntegerValue result = new IntegerValue(FunStringToCodepoints.getCodePointCount(strval));
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

