/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class FunString
extends Function {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("string", "http://www.w3.org/2005/xpath-functions"), "Returns the value of the context item as xs:string. If the context item is undefined, an error is raised.", new SequenceType[0], new FunctionReturnSequenceType(22, 2, "the value of the context item as an xs:string")), new FunctionSignature(new QName("string", "http://www.w3.org/2005/xpath-functions"), "Returns the value of $arg as xs:string. If the value of $arg is the empty sequence, the zero-length string is returned. If the context item of $arg is undefined, an error is raised.", new SequenceType[]{new FunctionParameterSequenceType("arg", 11, 3, "The sequence to get the vaule of as an xs:string")}, new FunctionReturnSequenceType(22, 2, "the value of $arg as an xs:string"))};

    public FunString(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if (this.getArgumentCount() == 1) {
            contextSequence = this.getArgument(0).eval(contextSequence);
            if (contextSequence.isEmpty()) {
                return StringValue.EMPTY_STRING;
            }
        } else {
            if (contextSequence == null) {
                throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Undefined context sequence for '" + this.toString() + "'");
            }
            if (contextSequence.isEmpty()) {
                return Sequence.EMPTY_SEQUENCE;
            }
        }
        AtomicValue result = contextSequence.convertTo(22);
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

