/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import org.exist.dom.QName;
import org.exist.dom.persistent.ExtArrayNodeSet;
import org.exist.dom.persistent.NodeSet;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AbstractSequence;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.ValueSequence;

public class FunSubSequence
extends Function {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("subsequence", "http://www.w3.org/2005/xpath-functions"), "Returns a subsequence of the items in $source-sequence, items starting at the position, $starting-at, up to the end of the sequence are included.", new SequenceType[]{new FunctionParameterSequenceType("source", 11, 7, "The source sequence"), new FunctionParameterSequenceType("starting-at", 34, 2, "The starting position in the $source")}, new FunctionReturnSequenceType(11, 7, "the subsequence")), new FunctionSignature(new QName("subsequence", "http://www.w3.org/2005/xpath-functions"), "Returns a subsequence of the items in $source, starting at the position, $starting-at,  including the number of items indicated by $length.", new SequenceType[]{new FunctionParameterSequenceType("source", 11, 7, "The source sequence"), new FunctionParameterSequenceType("starting-at", 34, 2, "The starting position in the $source"), new FunctionParameterSequenceType("length", 34, 2, "The length of the subsequence")}, new FunctionReturnSequenceType(11, 7, "the subsequence"))};

    public FunSubSequence(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        this.checkArguments();
        this.inPredicate = (contextInfo.getFlags() & 2) > 0;
        this.unordered = (contextInfo.getFlags() & 0x400) > 0;
        this.contextId = contextInfo.getContextId();
        contextInfo.setParent(this);
        for (int i = 0; i < this.getArgumentCount(); ++i) {
            AnalyzeContextInfo argContextInfo = new AnalyzeContextInfo(contextInfo);
            this.getArgument(i).analyze(argContextInfo);
            if (i != 0) continue;
            contextInfo.setStaticReturnType(argContextInfo.getStaticReturnType());
        }
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        Sequence seq;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if ((seq = this.getArgument(0).eval(contextSequence, contextItem)).isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            Item item;
            int i;
            AbstractSequence tmp;
            int start = ((DoubleValue)this.getArgument(1).eval(contextSequence, contextItem).convertTo(34)).getInt();
            int length = Integer.MAX_VALUE;
            if (this.getSignature().getArgumentCount() == 3) {
                length = ((DoubleValue)this.getArgument(2).eval(contextSequence, contextItem).convertTo(34)).getInt();
            }
            if (start < 0) {
                length = length + start - 1;
                start = 0;
            } else if (start == 0) {
                --length;
                --start;
            } else {
                --start;
            }
            if (seq instanceof NodeSet) {
                tmp = new ExtArrayNodeSet();
                ((ExtArrayNodeSet)tmp).keepUnOrdered(this.unordered);
            } else {
                tmp = new ValueSequence();
                ((ValueSequence)tmp).keepUnOrdered(this.unordered);
            }
            SequenceIterator iterator = seq.iterate();
            for (i = 0; i < start; ++i) {
                item = iterator.nextItem();
            }
            for (i = 0; iterator.hasNext() && i < length; ++i) {
                item = iterator.nextItem();
                tmp.add(item);
            }
            Sequence sequence = result = i > 0 ? tmp : Sequence.EMPTY_SEQUENCE;
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

