/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import java.io.StringWriter;
import java.io.Writer;
import org.exist.dom.QName;
import org.exist.storage.serializers.Serializer;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;
import org.xml.sax.SAXException;

public class FunTrace
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("trace", "http://www.w3.org/2005/xpath-functions"), "This function is intended to be used in debugging queries by providing a trace of their execution. The input $value is returned, unchanged, as the result of the function. In addition, the inputs $value, converted to an xs:string, and $label is directed to a trace data set in the eXist log files.", new SequenceType[]{new FunctionParameterSequenceType("value", 11, 7, "The value"), new FunctionParameterSequenceType("label", 22, 2, "The label in the log file")}, new FunctionReturnSequenceType(11, 7, "the labelled $value in the log"));

    public FunTrace(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence result;
        String label = args[1].getStringValue();
        if (label == null) {
            label = "";
        }
        Serializer serializer = this.context.getBroker().getSerializer();
        if (args[0].isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            result = new ValueSequence();
            int position = 0;
            SequenceIterator i = args[0].iterate();
            while (i.hasNext()) {
                Item next = i.nextItem();
                String value = null;
                ++position;
                int type = next.getType();
                if (1 == type) {
                    StringWriter sw = new StringWriter();
                    try {
                        serializer.serialize((NodeValue)next, (Writer)sw);
                    }
                    catch (SAXException ex) {
                        LOG.error(ex.getMessage());
                    }
                    value = ((Object)sw).toString();
                } else {
                    value = next.getStringValue();
                }
                LOG.info(label + " [" + position + "]: " + Type.getTypeName(type) + ": " + value);
                result.add(next);
            }
        }
        return result;
    }
}

