/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.fn.FunStringToCodepoints;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class FunTranslate
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("translate", "http://www.w3.org/2005/xpath-functions"), "Returns the value of $arg modified so that every character in the value of $arg that occurs at some position N in the value of $map has been replaced by the character that occurs at position N in the value of $trans.\n\nIf the value of $arg is the empty sequence, the zero-length string is returned.\n\nEvery character in the value of $arg that does not appear in the value of $map is unchanged.\n\nEvery character in the value of $arg that appears at some position M in the value of $map, where the value of $trans is less than M characters in length, is omitted from the returned value. If $map is the zero-length string $arg is returned.\n\nIf a character occurs more than once in $map, then the first occurrence determines the replacement character. If $trans is longer than $map, the excess characters are ignored.\n\ni.e. fn:translate(\"bar\",\"abc\",\"ABC\") returns \"BAr\"", new SequenceType[]{new FunctionParameterSequenceType("arg", 22, 3, "The string to be translated"), new FunctionParameterSequenceType("map", 22, 2, "The map string"), new FunctionParameterSequenceType("trans", 22, 2, "The translation string")}, new FunctionReturnSequenceType(22, 2, "the translated string"));

    public FunTranslate(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        StringValue result;
        Sequence seq;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if ((seq = this.getArgument(0).eval(contextSequence)).isEmpty()) {
            result = StringValue.EMPTY_STRING;
        } else {
            ValueSequence arg = FunStringToCodepoints.getCodePoints(seq.getStringValue());
            ValueSequence mapStr = FunStringToCodepoints.getCodePoints(this.getArgument(1).eval(contextSequence).getStringValue());
            ValueSequence transStr = FunStringToCodepoints.getCodePoints(this.getArgument(2).eval(contextSequence).getStringValue());
            StringBuilder buf = new StringBuilder(arg.getItemCount());
            for (int i = 0; i < arg.getItemCount(); ++i) {
                IntegerValue ch = (IntegerValue)arg.itemAt(i);
                int p = FunStringToCodepoints.indexOf(mapStr, ch);
                if (p == -1) {
                    buf.append(FunStringToCodepoints.codePointToString(ch));
                    continue;
                }
                if (p >= transStr.getItemCount()) continue;
                buf.append(FunStringToCodepoints.codePointToString((IntegerValue)transStr.itemAt(p)));
            }
            result = new StringValue(buf.toString());
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

