/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.fn;

import com.evolvedbinary.j8fu.function.ConsumerE;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.ExternalModule;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionCall;
import org.exist.xquery.FunctionDef;
import org.exist.xquery.FunctionFactory;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.InternalFunctionCall;
import org.exist.xquery.InternalModule;
import org.exist.xquery.Module;
import org.exist.xquery.UserDefinedFunction;
import org.exist.xquery.Variable;
import org.exist.xquery.VariableImpl;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.map.AbstractMapType;
import org.exist.xquery.functions.map.MapType;
import org.exist.xquery.parser.XQueryAST;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReference;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.QNameValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public class LoadXQueryModule
extends BasicFunction {
    public static final FunctionSignature LOAD_XQUERY_MODULE_1 = new FunctionSignature(new QName("load-xquery-module", "http://www.w3.org/2005/xpath-functions", ""), "Provides access to the public functions and global variables of a dynamically-loaded XQuery library module.", new SequenceType[]{new FunctionParameterSequenceType("module-uri", 22, 2, "The target namespace of the module")}, new FunctionReturnSequenceType(102, 2, "a map with two entries: 1) 'variables': a map with one entry for each public global variable declared in the library module. The key of the entry is the name of the variable, as an xs:QName value; the associated value is the value of the variable; 2) 'functions': a map which contains one entry for each public function declared in the library module, except that when two functions have the same name (but different arity), they share the same entry. The key of the entry is the name of the function(s), as an xs:QName value; the associated value is a map A. This map (A) contains one entry for each function with the given name; its key is the arity of the function, as an xs:integer value, and its associated value is the function itself, as a function item. The function can be invoked using the rules for dynamic function invocation."));
    public static final FunctionSignature LOAD_XQUERY_MODULE_2 = new FunctionSignature(new QName("load-xquery-module", "http://www.w3.org/2005/xpath-functions", ""), "Provides access to the public functions and global variables of a dynamically-loaded XQuery library module.", new SequenceType[]{new FunctionParameterSequenceType("module-uri", 22, 2, "The target namespace of the module"), new FunctionParameterSequenceType("options", 102, 2, "Options for loading the module")}, new FunctionReturnSequenceType(102, 2, "a map with two entries: 1) 'variables': a map with one entry for each public global variable declared in the library module. The key of the entry is the name of the variable, as an xs:QName value; the associated value is the value of the variable; 2) 'functions': a map which contains one entry for each public function declared in the library module, except that when two functions have the same name (but different arity), they share the same entry. The key of the entry is the name of the function(s), as an xs:QName value; the associated value is a map A. This map (A) contains one entry for each function with the given name; its key is the arity of the function, as an xs:integer value, and its associated value is the function itself, as a function item. The function can be invoked using the rules for dynamic function invocation."));
    public static final StringValue OPTIONS_LOCATION_HINTS = new StringValue("location-hints");
    public static final StringValue OPTIONS_XQUERY_VERSION = new StringValue("xquery-version");
    public static final StringValue OPTIONS_VARIABLES = new StringValue("variables");
    public static final StringValue OPTIONS_CONTEXT_ITEM = new StringValue("context-item");
    public static final StringValue OPTIONS_VENDOR = new StringValue("vendor-options");
    public static final StringValue RESULT_FUNCTIONS = new StringValue("functions");
    public static final StringValue RESULT_VARIABLES = new StringValue("variables");

    public LoadXQueryModule(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Module loadedModule;
        XQueryContext tempContext;
        Sequence contextItem;
        AbstractMapType externalVars;
        String xqVersion;
        String targetNamespace;
        block20: {
            targetNamespace = args[0].getStringValue();
            if (targetNamespace.length() == 0) {
                throw new XPathException((Expression)this, ErrorCodes.FOQM0001, "Target namespace must be a string with length > 0");
            }
            Sequence locationHints = Sequence.EMPTY_SEQUENCE;
            xqVersion = LoadXQueryModule.getXQueryVersion(this.context.getXQueryVersion());
            externalVars = new MapType(this.context);
            contextItem = Sequence.EMPTY_SEQUENCE;
            if (this.getArgumentCount() == 2) {
                Sequence vars;
                AbstractMapType map = (AbstractMapType)args[1].itemAt(0);
                locationHints = map.get(OPTIONS_LOCATION_HINTS);
                Sequence versions = map.get(OPTIONS_XQUERY_VERSION);
                if (!versions.isEmpty()) {
                    xqVersion = versions.itemAt(0).getStringValue();
                }
                if (!(vars = map.get(OPTIONS_VARIABLES)).isEmpty()) {
                    if (vars.hasOne() && vars.itemAt(0).getType() == 102) {
                        externalVars = (AbstractMapType)vars.itemAt(0);
                    } else {
                        throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "Option 'variables' must be a map");
                    }
                }
                if ((contextItem = map.get(OPTIONS_CONTEXT_ITEM)).getItemCount() > 1) {
                    throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "Option 'context-item' must contain zero or one items");
                }
            }
            tempContext = new XQueryContext(this.context.getBroker().getBrokerPool());
            tempContext.setModuleLoadPath(this.context.getModuleLoadPath());
            this.setExternalVars(externalVars, (ConsumerE<Variable, XPathException>)((ConsumerE)tempContext::declareGlobalVariable));
            loadedModule = null;
            try {
                if (locationHints.isEmpty()) {
                    loadedModule = tempContext.importModule(targetNamespace, null, null);
                    break block20;
                }
                SequenceIterator i = locationHints.iterate();
                while (i.hasNext()) {
                    String location = i.nextItem().getStringValue();
                    Module importedModule = tempContext.importModule(null, null, location);
                    if (importedModule == null || !importedModule.getNamespaceURI().equals(targetNamespace)) continue;
                    loadedModule = importedModule;
                    break;
                }
            }
            catch (XPathException e) {
                if (e.getErrorCode() == ErrorCodes.XQST0059) {
                    throw new XPathException((Expression)this, ErrorCodes.FOQM0002, "Module with URI " + targetNamespace + " not found");
                }
                throw new XPathException((Expression)this, ErrorCodes.FOQM0003, "Error found when importing module: " + e.getMessage());
            }
        }
        if (loadedModule == null) {
            throw new XPathException((Expression)this, ErrorCodes.FOQM0002, "Module with URI " + targetNamespace + " not found");
        }
        if (!xqVersion.equals(LoadXQueryModule.getXQueryVersion(tempContext.getXQueryVersion()))) {
            throw new XPathException(ErrorCodes.FOQM0003, "Imported module has wrong XQuery version: " + LoadXQueryModule.getXQueryVersion(tempContext.getXQueryVersion()));
        }
        Module module = loadedModule;
        module.setContextItem(contextItem);
        this.setExternalVars(externalVars, (ConsumerE<Variable, XPathException>)((ConsumerE)module::declareVariable));
        MapType result = new MapType(this.context);
        ValueSequence functionSeq = new ValueSequence();
        LoadXQueryModule.addFunctionRefsFromModule(this, tempContext, functionSeq, module);
        MapType functions = new MapType(this.context);
        SequenceIterator i = functionSeq.iterate();
        while (i.hasNext()) {
            MapType entry;
            FunctionReference ref = (FunctionReference)i.nextItem();
            FunctionSignature signature = ref.getSignature();
            QNameValue qn = new QNameValue(this.context, signature.getName());
            if (functions.contains(qn)) {
                entry = (MapType)functions.get(qn);
            } else {
                entry = new MapType(this.context);
                functions.add(qn, entry);
            }
            entry.add(new IntegerValue(signature.getArgumentCount()), ref);
        }
        result.add(RESULT_FUNCTIONS, functions);
        MapType variables = new MapType(this.context);
        Iterator<QName> i2 = module.getGlobalVariables();
        while (i2.hasNext()) {
            QName name = i2.next();
            try {
                Variable var = module.resolveVariable(name);
                variables.add(new QNameValue(this.context, name), var.getValue());
            }
            catch (XPathException e) {
                throw new XPathException((Expression)this, ErrorCodes.FOQM0005, "Incorrect type for external variable " + name);
            }
        }
        result.add(RESULT_VARIABLES, variables);
        return result;
    }

    private void setExternalVars(AbstractMapType externalVars, ConsumerE<Variable, XPathException> setter) throws XPathException {
        for (Map.Entry entry : externalVars) {
            if (!Type.subTypeOf(((AtomicValue)entry.getKey()).getType(), 24)) {
                throw new XPathException((Expression)this, ErrorCodes.XPTY0004, "name of external variable must be a qname: " + entry.getKey());
            }
            VariableImpl var = new VariableImpl(((QNameValue)entry.getKey()).getQName());
            var.setValue((Sequence)entry.getValue());
            setter.accept((Object)var);
        }
    }

    public static void addFunctionRefsFromModule(Expression parent, XQueryContext tempContext, ValueSequence resultSeq, Module module) throws XPathException {
        FunctionSignature[] signatures;
        for (FunctionSignature signature : signatures = module.listFunctions()) {
            if (signature.isPrivate()) continue;
            if (module.isInternalModule()) {
                int arity = signature.isOverloaded() ? signature.getArgumentTypes().length : signature.getArgumentCount();
                FunctionDef def = ((InternalModule)module).getFunctionDef(signature.getName(), arity);
                XQueryAST ast = new XQueryAST();
                ast.setLine(parent.getLine());
                ast.setColumn(parent.getColumn());
                ArrayList<Expression> args = new ArrayList<Expression>(arity);
                for (int i = 0; i < arity; ++i) {
                    args.add(new Function.Placeholder(tempContext));
                }
                Function fn = Function.createFunction(tempContext, ast, def);
                fn.setArguments(args);
                InternalFunctionCall call = new InternalFunctionCall(fn);
                FunctionCall ref = FunctionFactory.wrap(tempContext, call);
                resultSeq.addAll(new FunctionReference(ref));
                continue;
            }
            UserDefinedFunction func = ((ExternalModule)module).getFunction(signature.getName(), signature.getArgumentCount(), tempContext);
            if (func == null) continue;
            FunctionCall funcCall = new FunctionCall(tempContext, func);
            funcCall.setLocation(parent.getLine(), parent.getColumn());
            resultSeq.add(new FunctionReference(funcCall));
        }
    }

    private static String getXQueryVersion(int version) {
        return String.valueOf(version / 10) + '.' + String.valueOf(version % 10);
    }
}

