/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.inspect;

import java.util.Map;
import java.util.Set;
import org.exist.dom.QName;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.xquery.Annotation;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Cardinality;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.LiteralValue;
import org.exist.xquery.UserDefinedFunction;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.inspect.FunctionCallVisitor;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReference;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.exist.xquery.xqdoc.XQDocHelper;
import org.xml.sax.helpers.AttributesImpl;

public class InspectFunction
extends BasicFunction {
    public static final FunctionSignature SIGNATURE_DEPRECATED = new FunctionSignature(new QName("inspect-function", "http://exist-db.org/xquery/util", "util"), "Returns an XML fragment describing the function referenced by the passed function item.", new SequenceType[]{new FunctionParameterSequenceType("function", 101, 2, "The function item to inspect")}, new FunctionReturnSequenceType(-1, 2, "the signature of the function"));
    public static final FunctionSignature SIGNATURE = new FunctionSignature(new QName("inspect-function", "http://exist-db.org/xquery/inspection", "inspect"), "Returns an XML fragment describing the function referenced by the passed function item.", new SequenceType[]{new FunctionParameterSequenceType("function", 101, 2, "The function item to inspect")}, new FunctionReturnSequenceType(-1, 2, "the signature of the function"));
    protected static final QName ARGUMENT_QNAME = new QName("argument", "");
    protected static final QName DEPRECATED_QNAME = new QName("deprecated", "");
    protected static final QName DESCRIPTION_QNAME = new QName("description", "");
    protected static final QName RETURN_QNAME = new QName("returns", "");
    protected static final QName FUNCTION_QNAME = new QName("function", "");
    protected static final QName ANNOTATION_QNAME = new QName("annotation", "");
    protected static final QName ANNOTATION_VALUE_QNAME = new QName("value", "");
    protected static final QName VERSION_QNAME = new QName("version", "");
    protected static final QName AUTHOR_QNAME = new QName("author", "");
    protected static final QName CALLS_QNAME = new QName("calls", "");

    public InspectFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        FunctionReference ref = (FunctionReference)args[0].itemAt(0);
        FunctionSignature sig = ref.getSignature();
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        int nodeNr = InspectFunction.generateDocs(sig, null, builder);
        return builder.getDocument().getNode(nodeNr);
    }

    public static int generateDocs(FunctionSignature sig, UserDefinedFunction func, MemTreeBuilder builder) throws XPathException {
        Map<String, String> metadata;
        XQDocHelper.parse(sig);
        AttributesImpl attribs = new AttributesImpl();
        attribs.addAttribute("", "name", "name", "CDATA", sig.getName().toString());
        attribs.addAttribute("", "module", "module", "CDATA", sig.getName().getNamespaceURI());
        int nodeNr = builder.startElement(FUNCTION_QNAME, attribs);
        InspectFunction.writeParameters(sig, builder);
        SequenceType returnType = sig.getReturnType();
        if (returnType != null) {
            attribs.clear();
            attribs.addAttribute("", "type", "type", "CDATA", Type.getTypeName(returnType.getPrimaryType()));
            attribs.addAttribute("", "cardinality", "cardinality", "CDATA", Cardinality.getDescription(returnType.getCardinality()));
            builder.startElement(RETURN_QNAME, attribs);
            if (returnType instanceof FunctionReturnSequenceType) {
                FunctionReturnSequenceType type = (FunctionReturnSequenceType)returnType;
                builder.characters(type.getDescription());
            }
            builder.endElement();
        }
        InspectFunction.writeAnnotations(sig, builder);
        if (sig.getDescription() != null) {
            builder.startElement(DESCRIPTION_QNAME, null);
            builder.characters(sig.getDescription());
            builder.endElement();
        }
        if ((metadata = sig.getMetadata()) != null) {
            for (Map.Entry<String, String> meta : metadata.entrySet()) {
                builder.startElement(new QName(meta.getKey(), ""), null);
                builder.characters(meta.getValue());
                builder.endElement();
            }
        }
        if (sig.isDeprecated()) {
            builder.startElement(DEPRECATED_QNAME, null);
            builder.characters(sig.getDeprecated());
            builder.endElement();
        }
        if (func != null) {
            InspectFunction.generateDependencies(func, builder);
        }
        builder.endElement();
        return nodeNr;
    }

    private static void writeParameters(FunctionSignature sig, MemTreeBuilder builder) {
        SequenceType[] arguments = sig.getArgumentTypes();
        if (arguments != null) {
            AttributesImpl attribs = new AttributesImpl();
            for (SequenceType type : arguments) {
                attribs.clear();
                attribs.addAttribute("", "type", "type", "CDATA", Type.getTypeName(type.getPrimaryType()));
                attribs.addAttribute("", "cardinality", "cardinality", "CDATA", Cardinality.getDescription(type.getCardinality()));
                if (type instanceof FunctionParameterSequenceType) {
                    attribs.addAttribute("", "var", "var", "CDATA", ((FunctionParameterSequenceType)type).getAttributeName());
                }
                builder.startElement(ARGUMENT_QNAME, attribs);
                if (type instanceof FunctionParameterSequenceType) {
                    builder.characters(((FunctionParameterSequenceType)type).getDescription());
                }
                builder.endElement();
            }
        }
    }

    private static void writeAnnotations(FunctionSignature signature, MemTreeBuilder builder) throws XPathException {
        AttributesImpl attribs = new AttributesImpl();
        Annotation[] annots = signature.getAnnotations();
        if (annots != null) {
            for (Annotation annot : annots) {
                attribs.clear();
                attribs.addAttribute(null, "name", "name", "CDATA", annot.getName().toString());
                attribs.addAttribute(null, "namespace", "namespace", "CDATA", annot.getName().getNamespaceURI());
                builder.startElement(ANNOTATION_QNAME, attribs);
                LiteralValue[] value = annot.getValue();
                if (value != null) {
                    for (LiteralValue literal : value) {
                        builder.startElement(ANNOTATION_VALUE_QNAME, null);
                        builder.characters(literal.getValue().getStringValue());
                        builder.endElement();
                    }
                }
                builder.endElement();
            }
        }
    }

    public static void generateDependencies(UserDefinedFunction function, MemTreeBuilder builder) {
        FunctionCallVisitor visitor = new FunctionCallVisitor();
        function.getFunctionBody().accept(visitor);
        Set<FunctionSignature> signatures = visitor.getFunctionCalls();
        if (signatures.size() == 0) {
            return;
        }
        builder.startElement(CALLS_QNAME, null);
        AttributesImpl attribs = new AttributesImpl();
        for (FunctionSignature signature : signatures) {
            attribs.clear();
            attribs.addAttribute(null, "name", "name", "CDATA", signature.getName().toString());
            attribs.addAttribute("", "module", "module", "CDATA", signature.getName().getNamespaceURI());
            attribs.addAttribute("", "arity", "arity", "CDATA", Integer.toString(signature.getArgumentCount()));
            builder.startElement(FUNCTION_QNAME, attribs);
            builder.endElement();
        }
        builder.endElement();
    }
}

