/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.map;

import java.util.ArrayList;
import java.util.List;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.PathExpr;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.map.MapErrorCode;
import org.exist.xquery.functions.map.MapType;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class MapExpr
extends AbstractExpression {
    protected List<Mapping> mappings = new ArrayList<Mapping>(13);

    public MapExpr(XQueryContext context) {
        super(context);
    }

    public void map(PathExpr key, PathExpr value) {
        Mapping mapping = new Mapping(key.simplify(), value.simplify());
        this.mappings.add(mapping);
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        if (this.getContext().getXQueryVersion() < 30) {
            throw new XPathException((Expression)this, ErrorCodes.EXXQDY0003, "Map is not available before XQuery 3.0");
        }
        contextInfo.setParent(this);
        for (Mapping mapping : this.mappings) {
            mapping.key.analyze(contextInfo);
            mapping.value.analyze(contextInfo);
        }
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        MapType map = new MapType(this.context);
        for (Mapping mapping : this.mappings) {
            Sequence key = mapping.key.eval(contextSequence);
            if (key.getItemCount() != 1) {
                throw new XPathException(MapErrorCode.EXMPDY001, "Expected single value for key, got " + key.getItemCount());
            }
            AtomicValue atomic = key.itemAt(0).atomize();
            Sequence value = mapping.value.eval(contextSequence);
            map.add(atomic, value);
        }
        return map;
    }

    @Override
    public int returnsType() {
        return 102;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        super.accept(visitor);
        for (Mapping mapping : this.mappings) {
            mapping.key.accept(visitor);
            mapping.value.accept(visitor);
        }
    }

    @Override
    public void dump(ExpressionDumper dumper) {
        dumper.display("map {");
        for (Mapping mapping : this.mappings) {
            mapping.key.dump(dumper);
            dumper.display(" := ");
            mapping.value.dump(dumper);
        }
        dumper.display("}");
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.mappings.forEach(m -> ((Mapping)m).resetState(postOptimization));
    }

    private static class Mapping {
        final Expression key;
        final Expression value;

        public Mapping(Expression key, Expression value) {
            this.key = key;
            this.value = value;
        }

        private void resetState(boolean postOptimization) {
            this.key.resetState(postOptimization);
            this.value.resetState(postOptimization);
        }
    }
}

