/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.map;

import java.util.AbstractMap;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.map.AbstractMapType;
import org.exist.xquery.functions.map.MapType;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Sequence;

public class SingleKeyMapType
extends AbstractMapType {
    private AtomicValue key;
    private Sequence value;
    private Comparator<AtomicValue> comparator;

    public SingleKeyMapType(XQueryContext context, String collation, AtomicValue key, Sequence value) throws XPathException {
        super(context);
        this.key = key;
        this.value = value;
        this.comparator = this.getComparator(collation);
    }

    @Override
    public int getKeyType() {
        return this.key.getType();
    }

    @Override
    public Sequence get(AtomicValue key) {
        if (this.comparator.compare(this.key, key) == 0) {
            return this.value;
        }
        return null;
    }

    @Override
    public AbstractMapType put(AtomicValue key, Sequence value) throws XPathException {
        MapType map = new MapType(this.context);
        map.add(this);
        return map.put(key, value);
    }

    @Override
    public boolean contains(AtomicValue key) {
        return this.comparator.compare(this.key, key) == 0;
    }

    @Override
    public Sequence keys() {
        return this.key == null ? Sequence.EMPTY_SEQUENCE : this.key;
    }

    @Override
    public int size() {
        return this.key == null ? 0 : 1;
    }

    @Override
    public AbstractMapType remove(AtomicValue key) {
        try {
            return new MapType(this.context);
        }
        catch (XPathException e) {
            return null;
        }
    }

    @Override
    public AtomicValue getKey() {
        return this.key;
    }

    @Override
    public Sequence getValue() {
        return this.value;
    }

    @Override
    public Iterator<Map.Entry<AtomicValue, Sequence>> iterator() {
        return new SingleKeyMapIterator();
    }

    private class SingleKeyMapIterator
    implements Iterator<Map.Entry<AtomicValue, Sequence>> {
        boolean hasMore = true;

        private SingleKeyMapIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.hasMore;
        }

        @Override
        public Map.Entry<AtomicValue, Sequence> next() {
            if (!this.hasMore) {
                return null;
            }
            this.hasMore = false;
            return new AbstractMap.SimpleEntry<AtomicValue, Sequence>(SingleKeyMapType.this.key, SingleKeyMapType.this.value);
        }
    }
}

