/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.securitymanager;

import org.exist.EXistException;
import org.exist.config.ConfigurationException;
import org.exist.dom.QName;
import org.exist.security.AXSchemaType;
import org.exist.security.Account;
import org.exist.security.EXistSchemaType;
import org.exist.security.Group;
import org.exist.security.PermissionDeniedException;
import org.exist.security.SecurityManager;
import org.exist.security.Subject;
import org.exist.security.internal.Password;
import org.exist.security.internal.aider.GroupAider;
import org.exist.security.internal.aider.UserAider;
import org.exist.storage.DBBroker;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class AccountManagementFunction
extends BasicFunction {
    public static final QName qnCreateAccount = new QName("create-account", "http://exist-db.org/xquery/securitymanager", "sm");
    public static final QName qnRemoveAccount = new QName("remove-account", "http://exist-db.org/xquery/securitymanager", "sm");
    public static final QName qnPasswd = new QName("passwd", "http://exist-db.org/xquery/securitymanager", "sm");
    public static final QName qnPasswdHash = new QName("passwd-hash", "http://exist-db.org/xquery/securitymanager", "sm");
    public static final FunctionSignature FNS_CREATE_ACCOUNT = new FunctionSignature(qnCreateAccount, "Creates a User Account.", new SequenceType[]{new FunctionParameterSequenceType("username", 22, 2, "The User's username."), new FunctionParameterSequenceType("password", 22, 2, "The User's password."), new FunctionParameterSequenceType("primary-group", 22, 2, "The primary group of the user."), new FunctionParameterSequenceType("groups", 22, 7, "Any supplementary groups of which the user should be a member.")}, new SequenceType(10, 1));
    public static final FunctionSignature FNS_CREATE_ACCOUNT_WITH_METADATA = new FunctionSignature(qnCreateAccount, "Creates a User Account.", new SequenceType[]{new FunctionParameterSequenceType("username", 22, 2, "The User's username."), new FunctionParameterSequenceType("password", 22, 2, "The User's password."), new FunctionParameterSequenceType("primary-group", 22, 2, "The primary group of the user."), new FunctionParameterSequenceType("groups", 22, 7, "Any supplementary groups of which the user should be a member."), new FunctionParameterSequenceType("full-name", 22, 2, "The full name of the user."), new FunctionParameterSequenceType("description", 22, 2, "A description of the user.")}, new SequenceType(10, 1));
    public static final FunctionSignature FNS_CREATE_ACCOUNT_WITH_PERSONAL_GROUP = new FunctionSignature(qnCreateAccount, "Creates a User Account and a personal group for that user. The personal group takes the same name as the user, and is set as the user's primary group.", new SequenceType[]{new FunctionParameterSequenceType("username", 22, 2, "The User's username."), new FunctionParameterSequenceType("password", 22, 2, "The User's password."), new FunctionParameterSequenceType("groups", 22, 7, "Any supplementary groups of which the user should be a member.")}, new SequenceType(10, 1));
    public static final FunctionSignature FNS_CREATE_ACCOUNT_WITH_PERSONAL_GROUP_WITH_METADATA = new FunctionSignature(qnCreateAccount, "Creates a User Account and a personal group for that user. The personal group takes the same name as the user, and is set as the user's primary group.", new SequenceType[]{new FunctionParameterSequenceType("username", 22, 2, "The User's username."), new FunctionParameterSequenceType("password", 22, 2, "The User's password."), new FunctionParameterSequenceType("groups", 22, 7, "Any supplementary groups of which the user should be a member."), new FunctionParameterSequenceType("full-name", 22, 2, "The full name of the user."), new FunctionParameterSequenceType("description", 22, 2, "A description of the user.")}, new SequenceType(10, 1));
    public static final FunctionSignature FNS_REMOVE_ACCOUNT = new FunctionSignature(qnRemoveAccount, "Removes a User Account. If the user has a personal group you are responsible for removing that separately through sm:remove-group. ", new SequenceType[]{new FunctionParameterSequenceType("username", 22, 2, "The User's username.")}, new SequenceType(10, 1));
    public static final FunctionSignature FNS_PASSWD = new FunctionSignature(qnPasswd, "Changes the password of a User Account.", new SequenceType[]{new FunctionParameterSequenceType("username", 22, 2, "The User's username."), new FunctionParameterSequenceType("password", 22, 2, "The User's new password.")}, new SequenceType(10, 1));
    public static final FunctionSignature FNS_PASSWD_HASH = new FunctionSignature(qnPasswdHash, "Changes the password of a User Account by directly setting the stored digest password. The use-case for this function is migrating a user from one eXist instance to another.", new SequenceType[]{new FunctionParameterSequenceType("username", 22, 2, "The User's username."), new FunctionParameterSequenceType("password-digest", 22, 2, "The encoded digest of the User's new password (assumes eXist's default digest algorithm).")}, new SequenceType(10, 1));

    public AccountManagementFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        block20: {
            DBBroker broker = this.getContext().getBroker();
            Subject currentUser = broker.getCurrentSubject();
            SecurityManager securityManager = broker.getBrokerPool().getSecurityManager();
            String username = args[0].getStringValue();
            try {
                if (this.isCalledAs(qnRemoveAccount.getLocalPart())) {
                    if (!currentUser.hasDbaRole()) {
                        throw new XPathException("Only a DBA user may remove accounts.");
                    }
                    if (!securityManager.hasAccount(username)) {
                        throw new XPathException("The user account with username " + username + " does not exist.");
                    }
                    if (currentUser.getName().equals(username)) {
                        throw new XPathException("You cannot remove yourself i.e. the currently logged in user.");
                    }
                    securityManager.deleteAccount(username);
                    break block20;
                }
                String password = args[1].getStringValue();
                if (this.isCalledAs(qnPasswd.getLocalPart()) || this.isCalledAs(qnPasswdHash.getLocalPart())) {
                    if (!currentUser.getName().equals(username) && !currentUser.hasDbaRole()) {
                        throw new XPathException("You may only change your own password, unless you are a DBA.");
                    }
                    Account account = securityManager.getAccount(username);
                    if (this.isCalledAs(qnPasswdHash.getLocalPart())) {
                        account.setCredential(new Password(account, Password.DEFAULT_ALGORITHM, password));
                    } else {
                        account.setPassword(password);
                    }
                    securityManager.updateAccount(account);
                    break block20;
                }
                if (this.isCalledAs(qnCreateAccount.getLocalPart())) {
                    String[] subGroups;
                    Object group;
                    if (!currentUser.hasDbaRole()) {
                        throw new XPathException("You must be a DBA to create a User Account.");
                    }
                    if (securityManager.hasAccount(username)) {
                        throw new XPathException("The user account with username " + username + " already exists.");
                    }
                    UserAider user = new UserAider(username);
                    user.setPassword(password);
                    if (this.getSignature().getArgumentCount() >= 5) {
                        user.setMetadataValue(AXSchemaType.FULLNAME, args[this.getSignature().getArgumentCount() - 2].toString());
                        user.setMetadataValue(EXistSchemaType.DESCRIPTION, args[this.getSignature().getArgumentCount() - 1].toString());
                    }
                    if (this.getSignature().getArgumentCount() == 3 || this.getSignature().getArgumentCount() == 5) {
                        group = new GroupAider(username);
                        group.setMetadataValue(EXistSchemaType.DESCRIPTION, "Personal group for " + username);
                        group.addManager(currentUser);
                        securityManager.addGroup(broker, (Group)group);
                        user.addGroup(username);
                        subGroups = this.getGroups(args[2]);
                    } else {
                        user.addGroup(args[2].getStringValue());
                        subGroups = this.getGroups(args[3]);
                    }
                    for (String subGroup : subGroups) {
                        user.addGroup(subGroup);
                    }
                    securityManager.addAccount(user);
                    if (this.getSignature().getArgumentCount() == 3 || this.getSignature().getArgumentCount() == 5) {
                        group = securityManager.getGroup(username);
                        group.addManager(securityManager.getAccount(username));
                        securityManager.updateGroup((Group)group);
                    }
                    break block20;
                }
                throw new XPathException("Unknown function call: " + this.getSignature());
            }
            catch (PermissionDeniedException pde) {
                throw new XPathException((Expression)this, (Throwable)pde);
            }
            catch (ConfigurationException ce) {
                throw new XPathException((Expression)this, (Throwable)ce);
            }
            catch (EXistException ee) {
                throw new XPathException((Expression)this, (Throwable)ee);
            }
        }
        return Sequence.EMPTY_SEQUENCE;
    }

    private String[] getGroups(Sequence seq) {
        String[] groups = new String[seq.getItemCount()];
        for (int i = 0; i < seq.getItemCount(); ++i) {
            groups[i] = seq.itemAt(i).toString();
        }
        return groups;
    }
}

