/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.securitymanager;

import org.exist.dom.QName;
import org.exist.dom.memtree.DocumentImpl;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.security.Subject;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;

public class IdFunction
extends BasicFunction {
    public static final FunctionSignature FNS_ID = new FunctionSignature(new QName("id", "http://exist-db.org/xquery/securitymanager", "sm"), "Returns the user and group names of the account executing the XQuery. If the real and effective accounts are different, then both the real and effective account details are returned, otherwise only the real account details are returned.", null, new FunctionReturnSequenceType(6, 2, "Example output when an XQuery is running setUid <id xmlns=\"http://exist-db.org/xquery/securitymanager\"><real><username>guest</username><groups><group>guest</group></groups></real><effective><username>admin</username><groups><group>dba</group></groups></effective></id>."));

    public IdFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (this.mySignature == FNS_ID) {
            return this.functionId();
        }
        throw new XPathException("Unknown function call: " + this.getSignature());
    }

    private DocumentImpl functionId() throws XPathException {
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        builder.startDocument();
        builder.startElement(new QName("id", "http://exist-db.org/xquery/securitymanager", "sm"), null);
        builder.startElement(new QName("real", "http://exist-db.org/xquery/securitymanager", "sm"), null);
        this.subjectToXml(builder, this.context.getRealUser());
        builder.endElement();
        if (this.context.getRealUser().getId() != this.context.getEffectiveUser().getId()) {
            builder.startElement(new QName("effective", "http://exist-db.org/xquery/securitymanager", "sm"), null);
            this.subjectToXml(builder, this.context.getEffectiveUser());
            builder.endElement();
        }
        builder.endElement();
        builder.endDocument();
        return builder.getDocument();
    }

    private void subjectToXml(MemTreeBuilder builder, Subject subject) {
        builder.startElement(new QName("username", "http://exist-db.org/xquery/securitymanager", "sm"), null);
        builder.characters(subject.getName());
        builder.endElement();
        builder.startElement(new QName("groups", "http://exist-db.org/xquery/securitymanager", "sm"), null);
        for (String group : subject.getGroups()) {
            builder.startElement(new QName("group", "http://exist-db.org/xquery/securitymanager", "sm"), null);
            builder.characters(group);
            builder.endElement();
        }
        builder.endElement();
    }
}

