/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.securitymanager;

import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;

public class IsAuthenticatedFunction
extends BasicFunction {
    public static final FunctionSignature FNS_IS_AUTHENTICATED = new FunctionSignature(new QName("is-authenticated", "http://exist-db.org/xquery/securitymanager", "sm"), "Returns the true() if current account is authenticated, false() otherwise.", null, new FunctionReturnSequenceType(23, 2, "true() if user from the xquery context is authenticated, false() otherwise"));
    public static final FunctionSignature FNS_IS_EXTERNALLY_AUTHENTICATED = new FunctionSignature(new QName("is-externally-authenticated", "http://exist-db.org/xquery/securitymanager", "sm"), "Returns the true() if current account is authenticated by an external realm, false() otherwise.", null, new FunctionReturnSequenceType(23, 2, "true() if user from the xquery context is authenticated, false() otherwise"));

    public IsAuthenticatedFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (this.mySignature == FNS_IS_EXTERNALLY_AUTHENTICATED) {
            return new BooleanValue(this.context.getRealUser().isExternallyAuthenticated());
        }
        return new BooleanValue(this.context.getRealUser().isAuthenticated());
    }
}

