/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.securitymanager;

import com.evolvedbinary.j8fu.function.ConsumerE;
import org.exist.collections.Collection;
import org.exist.dom.QName;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.ACLPermission;
import org.exist.security.AbstractUnixStylePermission;
import org.exist.security.Permission;
import org.exist.security.PermissionDeniedException;
import org.exist.security.PermissionFactory;
import org.exist.security.SimpleACLPermission;
import org.exist.security.Subject;
import org.exist.util.SyntaxException;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class PermissionsFunction
extends BasicFunction {
    private static final QName qnGetPermissions = new QName("get-permissions", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnAddUserACE = new QName("add-user-ace", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnAddGroupACE = new QName("add-group-ace", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnInsertUserACE = new QName("insert-user-ace", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnInsertGroupACE = new QName("insert-group-ace", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnModifyACE = new QName("modify-ace", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnRemoveACE = new QName("remove-ace", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnClearACL = new QName("clear-acl", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnChMod = new QName("chmod", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnChOwn = new QName("chown", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnChGrp = new QName("chgrp", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnHasAccess = new QName("has-access", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnModeToOctal = new QName("mode-to-octal", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnOctalToMode = new QName("octal-to-mode", "http://exist-db.org/xquery/securitymanager", "sm");
    public static final FunctionSignature FNS_GET_PERMISSIONS = new FunctionSignature(qnGetPermissions, "Gets the permissions of a resource or collection.", new SequenceType[]{new FunctionParameterSequenceType("path", 25, 2, "The path to the resource or collection to get permissions of.")}, new FunctionReturnSequenceType(6, 2, "The permissions of the resource or collection"));
    public static final FunctionSignature FNS_ADD_USER_ACE = new FunctionSignature(qnAddUserACE, "Adds a User ACE to the ACL of a resource or collection.", new SequenceType[]{new FunctionParameterSequenceType("path", 25, 2, "The path to the resource or collection whose ACL you wish to add the ACE to."), new FunctionParameterSequenceType("user-name", 22, 2, "The name of the user to create an ACE for."), new FunctionParameterSequenceType("allowed", 23, 2, "true() if the ACE is allowing the permission mode, or false() if we are denying the permission mode"), new FunctionParameterSequenceType("mode", 22, 2, "The mode to set on the ACE e.g. 'rwx'")}, new SequenceType(10, 1));
    public static final FunctionSignature FNS_ADD_GROUP_ACE = new FunctionSignature(qnAddGroupACE, "Adds a Group ACE to the ACL of a resource or collection.", new SequenceType[]{new FunctionParameterSequenceType("path", 25, 2, "The path to the resource or collection whose ACL you wish to add the ACE to."), new FunctionParameterSequenceType("group-name", 22, 2, "The name of the group to create an ACE for."), new FunctionParameterSequenceType("allowed", 23, 2, "true() if the ACE is allowing the permission mode, or false() if we are denying the permission mode"), new FunctionParameterSequenceType("mode", 22, 2, "The mode to set on the ACE e.g. 'rwx'")}, new SequenceType(10, 1));
    public static final FunctionSignature FNS_INSERT_USER_ACE = new FunctionSignature(qnInsertUserACE, "Inserts a User ACE into the ACL of a resource or collection.", new SequenceType[]{new FunctionParameterSequenceType("path", 25, 2, "The path to the resource or collection whose ACL you wish to add the ACE to."), new FunctionParameterSequenceType("index", 38, 2, "The index in the ACL to insert the ACE before, subsequent entries will be renumbered"), new FunctionParameterSequenceType("user-name", 22, 2, "The name of the user to create an ACE for."), new FunctionParameterSequenceType("allowed", 23, 2, "true() if the ACE is allowing the permission mode, or false() if we are denying the permission mode"), new FunctionParameterSequenceType("mode", 22, 2, "The mode to set on the ACE e.g. 'rwx'")}, new SequenceType(10, 1));
    public static final FunctionSignature FNS_INSERT_GROUP_ACE = new FunctionSignature(qnInsertGroupACE, "Inserts a Group ACE into the ACL of a resource or collection.", new SequenceType[]{new FunctionParameterSequenceType("path", 25, 2, "The path to the resource or collection whose ACL you wish to add the ACE to."), new FunctionParameterSequenceType("index", 38, 2, "The index in the ACL to insert the ACE before, subsequent entries will be renumbered"), new FunctionParameterSequenceType("group-name", 22, 2, "The name of the group to create an ACE for."), new FunctionParameterSequenceType("allowed", 23, 2, "true() if the ACE is allowing the permission mode, or false() if we are denying the permission mode"), new FunctionParameterSequenceType("mode", 22, 2, "The mode to set on the ACE e.g. 'rwx'")}, new SequenceType(10, 1));
    public static final FunctionSignature FNS_MODIFY_ACE = new FunctionSignature(qnModifyACE, "Modified an ACE of an ACL of a resource or collection.", new SequenceType[]{new FunctionParameterSequenceType("path", 25, 2, "The path to the resource or collection whose ACL you wish to modify the ACE of."), new FunctionParameterSequenceType("index", 38, 2, "The index of the ACE in the ACL to modify"), new FunctionParameterSequenceType("allowed", 23, 2, "true() if the ACE is allowing the permission mode, or false() if we are denying the permission mode"), new FunctionParameterSequenceType("mode", 22, 2, "The mode to set on the ACE e.g. 'rwx'")}, new SequenceType(10, 1));
    public static final FunctionSignature FNS_REMOVE_ACE = new FunctionSignature(qnRemoveACE, "Removes an ACE from the ACL of a resource or collection.", new SequenceType[]{new FunctionParameterSequenceType("path", 25, 2, "The path to the resource or collection whose ACL you wish to remove the ACE from."), new FunctionParameterSequenceType("index", 38, 2, "The index of the ACE in the ACL to remove, subsequent entries will be renumbered")}, new SequenceType(10, 1));
    public static final FunctionSignature FNS_CLEAR_ACL = new FunctionSignature(qnClearACL, "Removes all ACEs from the ACL of a resource or collection.", new SequenceType[]{new FunctionParameterSequenceType("path", 25, 2, "The path to the resource or collection whose ACL you wish to clear.")}, new SequenceType(10, 1));
    public static final FunctionSignature FNS_CHMOD = new FunctionSignature(qnChMod, "Changes the mode of a resource or collection.", new SequenceType[]{new FunctionParameterSequenceType("path", 25, 2, "The path to the resource or collection whose mode you wish to set"), new FunctionParameterSequenceType("mode", 22, 2, "The mode to set on the resource or collection e.g. 'rwxrwxrwx'")}, new SequenceType(10, 1));
    public static final FunctionSignature FNS_CHOWN = new FunctionSignature(qnChOwn, "Changes the owner of a resource or collection.", new SequenceType[]{new FunctionParameterSequenceType("path", 25, 2, "The path to the resource or collection whose owner you wish to set"), new FunctionParameterSequenceType("owner", 22, 2, "The name of the user owner to set on the resource or collection e.g. 'guest'. You may also provide a group owner, by using the syntax 'user:group' if you wish.")}, new SequenceType(10, 1));
    public static final FunctionSignature FNS_CHGRP = new FunctionSignature(qnChGrp, "Changes the group owner of a resource or collection.", new SequenceType[]{new FunctionParameterSequenceType("path", 25, 2, "The path to the resource or collection whose group owner you wish to set"), new FunctionParameterSequenceType("group-name", 22, 2, "The name of the user group owner to set on the resource or collection e.g. 'guest'")}, new SequenceType(10, 1));
    public static final FunctionSignature FNS_HAS_ACCESS = new FunctionSignature(qnHasAccess, "Checks whether the current user has access to the resource or collection.", new SequenceType[]{new FunctionParameterSequenceType("path", 25, 2, "The path to the resource or collection whose access of which you wish to check"), new FunctionParameterSequenceType("mode", 22, 2, "The partial mode to check against the resource or collection e.g. 'rwx'")}, new SequenceType(23, 2));
    public static final FunctionSignature FNS_MODE_TO_OCTAL = new FunctionSignature(qnModeToOctal, "Converts a mode string e.g. 'rwxrwxrwx' to an octal number e.g. 0777.", new SequenceType[]{new FunctionParameterSequenceType("mode", 22, 2, "The mode to convert to an octal string.")}, new SequenceType(22, 2));
    public static final FunctionSignature FNS_OCTAL_TO_MODE = new FunctionSignature(qnOctalToMode, "Converts an octal string e.g. '0777' to a mode string e.g. 'rwxrwxrwx'.", new SequenceType[]{new FunctionParameterSequenceType("octal", 22, 2, "The octal string to convert to a mode.")}, new SequenceType(22, 2));
    static final char OWNER_GROUP_SEPARATOR = ':';

    public PermissionsFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence result;
        if (this.isCalledAs(qnModeToOctal.getLocalPart())) {
            String mode = args[0].itemAt(0).getStringValue();
            result = this.functionModeToOctal(mode);
        } else if (this.isCalledAs(qnOctalToMode.getLocalPart())) {
            String octal = args[0].itemAt(0).getStringValue();
            result = this.functionOctalToMode(octal);
        } else {
            XmldbURI pathUri = ((AnyURIValue)args[0].itemAt(0)).toXmldbURI();
            try {
                if (this.isCalledAs(qnGetPermissions.getLocalPart())) {
                    result = this.functionGetPermissions(pathUri);
                } else if (this.isCalledAs(qnAddUserACE.getLocalPart()) || this.isCalledAs(qnAddGroupACE.getLocalPart())) {
                    ACLPermission.ACE_TARGET target = this.isCalledAs(qnAddUserACE.getLocalPart()) ? ACLPermission.ACE_TARGET.USER : ACLPermission.ACE_TARGET.GROUP;
                    String name = args[1].getStringValue();
                    ACLPermission.ACE_ACCESS_TYPE access_type = args[2].effectiveBooleanValue() ? ACLPermission.ACE_ACCESS_TYPE.ALLOWED : ACLPermission.ACE_ACCESS_TYPE.DENIED;
                    String mode = args[3].itemAt(0).getStringValue();
                    result = this.functionAddACE(pathUri, target, name, access_type, mode);
                } else if (this.isCalledAs(qnInsertUserACE.getLocalPart()) || this.isCalledAs(qnInsertGroupACE.getLocalPart())) {
                    ACLPermission.ACE_TARGET target = this.isCalledAs(qnInsertUserACE.getLocalPart()) ? ACLPermission.ACE_TARGET.USER : ACLPermission.ACE_TARGET.GROUP;
                    int index = args[1].itemAt(0).toJavaObject(Integer.class);
                    String name = args[2].getStringValue();
                    ACLPermission.ACE_ACCESS_TYPE access_type = args[3].effectiveBooleanValue() ? ACLPermission.ACE_ACCESS_TYPE.ALLOWED : ACLPermission.ACE_ACCESS_TYPE.DENIED;
                    String mode = args[4].itemAt(0).getStringValue();
                    result = this.functionInsertACE(pathUri, index, target, name, access_type, mode);
                } else if (this.isCalledAs(qnModifyACE.getLocalPart())) {
                    int index = args[1].itemAt(0).toJavaObject(Integer.class);
                    ACLPermission.ACE_ACCESS_TYPE access_type = args[2].effectiveBooleanValue() ? ACLPermission.ACE_ACCESS_TYPE.ALLOWED : ACLPermission.ACE_ACCESS_TYPE.DENIED;
                    String mode = args[3].itemAt(0).getStringValue();
                    result = this.functionModifyACE(pathUri, index, access_type, mode);
                } else if (this.isCalledAs(qnRemoveACE.getLocalPart())) {
                    int index = args[1].itemAt(0).toJavaObject(Integer.class);
                    result = this.functionRemoveACE(pathUri, index);
                } else if (this.isCalledAs(qnClearACL.getLocalPart())) {
                    result = this.functionClearACL(pathUri);
                } else if (this.isCalledAs(qnChMod.getLocalPart())) {
                    String mode = args[1].itemAt(0).getStringValue();
                    result = this.functionChMod(pathUri, mode);
                } else if (this.isCalledAs(qnChOwn.getLocalPart())) {
                    String owner = args[1].itemAt(0).getStringValue();
                    result = this.functionChOwn(pathUri, owner);
                } else if (this.isCalledAs(qnChGrp.getLocalPart())) {
                    String groupname = args[1].itemAt(0).getStringValue();
                    result = this.functionChGrp(pathUri, groupname);
                } else if (this.isCalledAs(qnHasAccess.getLocalPart())) {
                    String mode = args[1].itemAt(0).getStringValue();
                    result = this.functionHasAccess(pathUri, mode);
                } else {
                    result = Sequence.EMPTY_SEQUENCE;
                }
            }
            catch (PermissionDeniedException pde) {
                throw new XPathException((Expression)this, (Throwable)pde);
            }
        }
        return result;
    }

    private org.exist.dom.memtree.DocumentImpl functionGetPermissions(XmldbURI pathUri) throws XPathException {
        try {
            return this.permissionsToXml(this.getPermissions(pathUri));
        }
        catch (PermissionDeniedException pde) {
            throw new XPathException((Expression)this, "Permission to retrieve permissions is denied for user '" + this.context.getSubject().getName() + "' on '" + pathUri.toString() + "': " + pde.getMessage(), (Throwable)pde);
        }
    }

    private Sequence functionAddACE(XmldbURI pathUri, ACLPermission.ACE_TARGET target, String name, ACLPermission.ACE_ACCESS_TYPE access_type, String mode) throws PermissionDeniedException {
        PermissionFactory.updatePermissions(this.context.getBroker(), pathUri, this.forAcl((ConsumerE<SimpleACLPermission, PermissionDeniedException>)((ConsumerE)aclPermission -> aclPermission.addACE(access_type, target, name, mode))));
        return Sequence.EMPTY_SEQUENCE;
    }

    private Sequence functionInsertACE(XmldbURI pathUri, int index, ACLPermission.ACE_TARGET target, String name, ACLPermission.ACE_ACCESS_TYPE access_type, String mode) throws PermissionDeniedException {
        PermissionFactory.updatePermissions(this.context.getBroker(), pathUri, this.forAcl((ConsumerE<SimpleACLPermission, PermissionDeniedException>)((ConsumerE)aclPermission -> aclPermission.insertACE(index, access_type, target, name, mode))));
        return Sequence.EMPTY_SEQUENCE;
    }

    private Sequence functionModifyACE(XmldbURI pathUri, int index, ACLPermission.ACE_ACCESS_TYPE access_type, String mode) throws PermissionDeniedException {
        PermissionFactory.updatePermissions(this.context.getBroker(), pathUri, this.forAcl((ConsumerE<SimpleACLPermission, PermissionDeniedException>)((ConsumerE)aclPermission -> aclPermission.modifyACE(index, access_type, mode))));
        return Sequence.EMPTY_SEQUENCE;
    }

    private Sequence functionRemoveACE(XmldbURI pathUri, int index) throws PermissionDeniedException {
        PermissionFactory.updatePermissions(this.context.getBroker(), pathUri, this.forAcl((ConsumerE<SimpleACLPermission, PermissionDeniedException>)((ConsumerE)aclPermission -> aclPermission.removeACE(index))));
        return Sequence.EMPTY_SEQUENCE;
    }

    private Sequence functionClearACL(XmldbURI pathUri) throws PermissionDeniedException {
        PermissionFactory.updatePermissions(this.context.getBroker(), pathUri, this.forAcl((ConsumerE<SimpleACLPermission, PermissionDeniedException>)((ConsumerE)aclPermission -> aclPermission.clear())));
        return Sequence.EMPTY_SEQUENCE;
    }

    private Sequence functionChMod(XmldbURI pathUri, String modeStr) throws PermissionDeniedException {
        PermissionFactory.updatePermissions(this.context.getBroker(), pathUri, (ConsumerE<Permission, PermissionDeniedException>)((ConsumerE)permission -> {
            try {
                permission.setMode(modeStr);
            }
            catch (SyntaxException se) {
                throw new PermissionDeniedException("Unrecognised mode syntax: " + se.getMessage(), se);
            }
        }));
        return Sequence.EMPTY_SEQUENCE;
    }

    private Sequence functionChOwn(XmldbURI pathUri, String owner) throws PermissionDeniedException {
        PermissionFactory.updatePermissions(this.context.getBroker(), pathUri, (ConsumerE<Permission, PermissionDeniedException>)((ConsumerE)permission -> {
            if (owner.indexOf(58) > -1) {
                permission.setOwner(owner.substring(0, owner.indexOf(58)));
                permission.setGroup(owner.substring(owner.indexOf(58) + 1));
            } else {
                permission.setOwner(owner);
            }
        }));
        return Sequence.EMPTY_SEQUENCE;
    }

    private Sequence functionChGrp(XmldbURI pathUri, String groupname) throws PermissionDeniedException {
        PermissionFactory.updatePermissions(this.context.getBroker(), pathUri, (ConsumerE<Permission, PermissionDeniedException>)((ConsumerE)permission -> permission.setGroup(groupname)));
        return Sequence.EMPTY_SEQUENCE;
    }

    private Sequence functionHasAccess(XmldbURI pathUri, String modeStr) throws XPathException {
        if (modeStr == null || modeStr.length() == 0 || modeStr.length() > 3) {
            throw new XPathException("Mode string must be partial i.e. rwx not rwxrwxrwx");
        }
        int mode = 0;
        if (modeStr.indexOf(114) > -1) {
            mode |= 4;
        }
        if (modeStr.indexOf(119) > -1) {
            mode |= 2;
        }
        if (modeStr.indexOf(120) > -1) {
            mode |= 1;
        }
        Subject effectiveSubject = this.context.getEffectiveUser();
        try {
            boolean hasAccess = this.getPermissions(pathUri).validate(effectiveSubject, mode);
            return BooleanValue.valueOf(hasAccess);
        }
        catch (XPathException xpe) {
            LOG.error(xpe.getMessage(), (Throwable)xpe);
            return BooleanValue.FALSE;
        }
        catch (PermissionDeniedException pde) {
            return BooleanValue.FALSE;
        }
    }

    private Sequence functionModeToOctal(String modeStr) throws XPathException {
        try {
            int mode = AbstractUnixStylePermission.simpleSymbolicModeToInt(modeStr);
            String octal = mode == 0 ? "0" : "0" + Integer.toOctalString(mode);
            return new StringValue(octal);
        }
        catch (SyntaxException se) {
            throw new XPathException(se.getMessage(), (Throwable)se);
        }
    }

    private Sequence functionOctalToMode(String octal) {
        int mode = Integer.parseInt(octal, 8);
        return new StringValue(AbstractUnixStylePermission.modeToSimpleSymbolicMode(mode));
    }

    private Permission getPermissions(XmldbURI pathUri) throws XPathException, PermissionDeniedException {
        Permission permissions;
        Collection col = this.context.getBroker().getCollection(pathUri);
        if (col != null) {
            permissions = col.getPermissionsNoLock();
        } else {
            DocumentImpl doc = this.context.getBroker().getResource(pathUri, 4);
            if (doc != null) {
                permissions = doc.getPermissions();
            } else {
                throw new XPathException("Resource or collection '" + pathUri.toString() + "' does not exist.");
            }
        }
        return permissions;
    }

    private org.exist.dom.memtree.DocumentImpl permissionsToXml(Permission permission) {
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        builder.startDocument();
        builder.startElement(new QName("permission", "http://exist-db.org/xquery/securitymanager", "sm"), null);
        builder.addAttribute(new QName("owner", ""), permission.getOwner().getName());
        builder.addAttribute(new QName("group", ""), permission.getGroup().getName());
        builder.addAttribute(new QName("mode", ""), permission.toString());
        if (permission instanceof SimpleACLPermission) {
            SimpleACLPermission aclPermission = (SimpleACLPermission)permission;
            builder.startElement(new QName("acl", "http://exist-db.org/xquery/securitymanager", "sm"), null);
            builder.addAttribute(new QName("entries", ""), String.valueOf(aclPermission.getACECount()));
            for (int i = 0; i < aclPermission.getACECount(); ++i) {
                builder.startElement(new QName("ace", "http://exist-db.org/xquery/securitymanager", "sm"), null);
                builder.addAttribute(new QName("index", ""), String.valueOf(i));
                builder.addAttribute(new QName("target", ""), aclPermission.getACETarget(i).name());
                builder.addAttribute(new QName("who", ""), aclPermission.getACEWho(i));
                builder.addAttribute(new QName("access_type", ""), aclPermission.getACEAccessType(i).name());
                builder.addAttribute(new QName("mode", ""), aclPermission.getACEModeString(i));
                builder.endElement();
            }
            builder.endElement();
        }
        builder.endElement();
        builder.endDocument();
        return builder.getDocument();
    }

    private ConsumerE<Permission, PermissionDeniedException> forAcl(ConsumerE<SimpleACLPermission, PermissionDeniedException> aclPermissionModifier) {
        return permission -> {
            if (!(permission instanceof SimpleACLPermission)) {
                throw new PermissionDeniedException("ACL like permissions have not been enabled");
            }
            SimpleACLPermission aclPermission = (SimpleACLPermission)permission;
            aclPermissionModifier.accept((Object)aclPermission);
        };
    }
}

