/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.securitymanager;

import org.exist.EXistException;
import org.exist.dom.QName;
import org.exist.security.AXSchemaType;
import org.exist.security.Account;
import org.exist.security.EXistSchemaType;
import org.exist.security.Group;
import org.exist.security.PermissionDeniedException;
import org.exist.security.Principal;
import org.exist.security.SchemaType;
import org.exist.security.SecurityManager;
import org.exist.security.Subject;
import org.exist.storage.DBBroker;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.securitymanager.GetPrincipalMetadataFunction;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class SetPrincipalMetadataFunction
extends BasicFunction {
    private static final QName qnSetAccountMetadata = new QName("set-account-metadata", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnSetGroupMetadata = new QName("set-group-metadata", "http://exist-db.org/xquery/securitymanager", "sm");
    public static final FunctionSignature FNS_SET_ACCOUNT_METADATA = new FunctionSignature(qnSetAccountMetadata, "Sets a metadata attribute value for an account", new SequenceType[]{new FunctionParameterSequenceType("username", 22, 2, "The username of the account to set metadata for."), new FunctionParameterSequenceType("attribute", 25, 2, "The metadata attribute key."), new FunctionParameterSequenceType("value", 22, 2, "The metadata value,")}, new SequenceType(10, 1));
    public static final FunctionSignature FNS_SET_GROUP_METADATA = new FunctionSignature(qnSetGroupMetadata, "Sets a metadata attribute value for a group", new SequenceType[]{new FunctionParameterSequenceType("group-name", 22, 2, "The name of the group to set metadata for."), new FunctionParameterSequenceType("attribute", 25, 2, "The metadata attribute key."), new FunctionParameterSequenceType("value", 22, 2, "The metadata value,")}, new SequenceType(10, 1));

    public SetPrincipalMetadataFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Principal principal;
        DBBroker broker = this.getContext().getBroker();
        Subject currentUser = broker.getCurrentSubject();
        if (currentUser.getName().equals("guest")) {
            throw new XPathException("You must be an authenticated user");
        }
        SecurityManager securityManager = broker.getBrokerPool().getSecurityManager();
        String strPrincipal = args[0].getStringValue();
        String metadataAttributeNamespace = args[1].getStringValue();
        String value = args[2].getStringValue();
        if (this.isCalledAs(qnSetAccountMetadata.getLocalPart())) {
            if (!currentUser.hasDbaRole() && !currentUser.getUsername().equals(strPrincipal)) {
                throw new XPathException((Expression)this, (Throwable)new PermissionDeniedException("You must have suitable access rights to modify the users metadata."));
            }
            principal = securityManager.getAccount(strPrincipal);
        } else if (this.isCalledAs(qnSetGroupMetadata.getLocalPart())) {
            boolean valid = false;
            for (SchemaType groupMetadataKey : GetPrincipalMetadataFunction.GROUP_METADATA_KEYS) {
                if (!groupMetadataKey.getNamespace().equals(metadataAttributeNamespace)) continue;
                valid = true;
                break;
            }
            if (!valid) {
                throw new XPathException("The metadata attribute key '" + metadataAttributeNamespace + "' is not valid on a group.");
            }
            Group group = securityManager.getGroup(strPrincipal);
            if (!currentUser.hasDbaRole() && !group.isManager(currentUser)) {
                throw new XPathException((Expression)this, (Throwable)new PermissionDeniedException("You must have suitable access rights to modify the groups metadata."));
            }
            principal = group;
        } else {
            throw new XPathException((Expression)this, "Unknown function");
        }
        this.setAccountMetadata(securityManager, principal, metadataAttributeNamespace, value);
        return Sequence.EMPTY_SEQUENCE;
    }

    private void setAccountMetadata(SecurityManager securityManager, Principal principal, String metadataAttributeNamespace, String value) throws XPathException {
        Enum schemaType = AXSchemaType.valueOfNamespace(metadataAttributeNamespace);
        if (schemaType == null) {
            schemaType = EXistSchemaType.valueOfNamespace(metadataAttributeNamespace);
        }
        if (schemaType == null) {
            throw new XPathException("Unknown metadata attribute key: " + metadataAttributeNamespace);
        }
        principal.setMetadataValue((SchemaType)((Object)schemaType), value);
        try {
            if (principal instanceof Account) {
                securityManager.updateAccount((Account)principal);
            } else if (principal instanceof Group) {
                securityManager.updateGroup((Group)principal);
            }
        }
        catch (PermissionDeniedException pde) {
            throw new XPathException((Expression)this, (Throwable)pde);
        }
        catch (EXistException ee) {
            throw new XPathException((Expression)this, (Throwable)ee);
        }
    }
}

